/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal;

import java.net.HttpURLConnection;
import java.util.StringTokenizer;
import org.apache.cactus.Cookie;
import org.apache.cactus.HttpSessionCookie;
import org.apache.cactus.Request;
import org.apache.cactus.ServletURL;
import org.apache.cactus.WebResponse;
import org.apache.cactus.internal.BaseWebRequest;
import org.apache.cactus.internal.RequestDirectives;
import org.apache.cactus.internal.ServiceEnumeration;
import org.apache.cactus.internal.client.ClientException;
import org.apache.cactus.internal.client.WebResponseObjectFactory;
import org.apache.cactus.internal.client.connector.http.HttpClientConnectionHelper;
import org.apache.cactus.internal.configuration.WebConfiguration;
import org.apache.cactus.util.ChainedRuntimeException;

public class WebRequestImpl
extends BaseWebRequest {
    private ServletURL url;
    private boolean isAutomaticSession = true;
    private String redirectorName;

    public WebRequestImpl() {
    }

    public WebRequestImpl(WebConfiguration theConfiguration) {
        super(theConfiguration);
    }

    public void setRedirectorName(String theRedirectorName) {
        this.redirectorName = theRedirectorName;
    }

    public String getRedirectorName() {
        return this.redirectorName;
    }

    public void setAutomaticSession(boolean isAutomaticSession) {
        this.isAutomaticSession = isAutomaticSession;
    }

    public boolean getAutomaticSession() {
        return this.isAutomaticSession;
    }

    public void setURL(String theServerName, String theContextPath, String theServletPath, String thePathInfo, String theQueryString) {
        this.url = new ServletURL(theServerName, theContextPath, theServletPath, thePathInfo, theQueryString);
        this.addQueryStringParameters(theQueryString);
    }

    public ServletURL getURL() {
        return this.url;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("simulation URL = [" + this.getURL() + "], ");
        buffer.append("automatic session = [" + this.getAutomaticSession() + "], ");
        buffer.append(super.toString());
        return buffer.toString();
    }

    private void addQueryStringParameters(String theQueryString) {
        if (theQueryString == null) {
            return;
        }
        String nameValue = null;
        StringTokenizer tokenizer = new StringTokenizer(theQueryString, "&");
        int breakParam = -1;
        while (tokenizer.hasMoreTokens()) {
            nameValue = tokenizer.nextToken();
            breakParam = nameValue.indexOf("=");
            if (breakParam != -1) {
                this.addParameter(nameValue.substring(0, breakParam), nameValue.substring(breakParam + 1));
                continue;
            }
            throw new RuntimeException("Bad QueryString [" + theQueryString + "] NameValue pair: [" + nameValue + "]");
        }
    }

    public HttpSessionCookie getSessionCookie() {
        WebResponse response;
        HttpURLConnection resultConnection;
        if (this.getConfiguration() == null) {
            throw new ChainedRuntimeException("setConfiguration() should have been called prior to calling getSessionCookie()");
        }
        HttpClientConnectionHelper helper = new HttpClientConnectionHelper(((WebConfiguration)this.getConfiguration()).getRedirectorURL(this));
        WebRequestImpl obtainSessionIdRequest = new WebRequestImpl((WebConfiguration)this.getConfiguration());
        RequestDirectives directives = new RequestDirectives(obtainSessionIdRequest);
        directives.setService(ServiceEnumeration.CREATE_SESSION_SERVICE);
        try {
            resultConnection = helper.connect(obtainSessionIdRequest, this.getConfiguration());
        }
        catch (Throwable e) {
            throw new ChainedRuntimeException("Failed to connect to [" + ((WebConfiguration)this.getConfiguration()).getRedirectorURL(this) + "]", e);
        }
        try {
            response = (WebResponse)new WebResponseObjectFactory(resultConnection).getResponseObject(WebResponse.class.getName(), (Request)obtainSessionIdRequest);
        }
        catch (ClientException e) {
            throw new ChainedRuntimeException("Failed to connect to [" + ((WebConfiguration)this.getConfiguration()).getRedirectorURL(this) + "]", (Throwable)((Object)e));
        }
        Cookie cookie = response.getCookieIgnoreCase("jsessionid");
        HttpSessionCookie sessionCookie = null;
        if (cookie != null) {
            sessionCookie = new HttpSessionCookie(cookie.getDomain(), cookie.getName(), cookie.getValue());
            sessionCookie.setComment(cookie.getComment());
            sessionCookie.setExpiryDate(cookie.getExpiryDate());
            sessionCookie.setPath(cookie.getPath());
            sessionCookie.setSecure(cookie.isSecure());
        }
        return sessionCookie;
    }
}

