/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.cactus.Request;
import org.apache.cactus.internal.client.ClientException;
import org.apache.cactus.internal.util.JUnitVersionHelper;
import org.apache.cactus.internal.util.TestCaseImplementChecker;
import org.apache.cactus.spi.client.ResponseObjectFactory;
import org.apache.cactus.spi.client.connector.ProtocolHandler;
import org.apache.cactus.spi.client.connector.ProtocolState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientTestCaseCaller
extends Assert {
    protected static final String TEST_METHOD_PREFIX = "test";
    protected static final String BEGIN_METHOD_PREFIX = "begin";
    protected static final String END_METHOD_PREFIX = "end";
    protected static final String CLIENT_GLOBAL_BEGIN_METHOD = "begin";
    protected static final String CLIENT_GLOBAL_END_METHOD = "end";
    private Log logger;
    private Test wrappedTest;
    private Test delegatedTest;
    private ProtocolHandler protocolHandler;

    public ClientTestCaseCaller(Test theDelegatedTest, Test theWrappedTest, ProtocolHandler theProtocolHandler) {
        if (theDelegatedTest == null) {
            throw new IllegalStateException("The test object passed must not be null");
        }
        this.setDelegatedTest(theDelegatedTest);
        this.setWrappedTest(theWrappedTest);
        this.protocolHandler = theProtocolHandler;
    }

    public void runTest() throws Throwable {
        Request request = this.protocolHandler.createRequest();
        this.callGlobalBeginMethod(request);
        this.callBeginMethod(request);
        ProtocolState state = this.protocolHandler.runTest(this.getDelegatedTest(), this.getWrappedTest(), request);
        Object response = this.callEndMethod(request, this.protocolHandler.createResponseObjectFactory(state));
        this.callGlobalEndMethod(request, this.protocolHandler.createResponseObjectFactory(state), response);
        this.protocolHandler.afterTest(state);
    }

    public final Log getLogger() {
        return this.logger;
    }

    public void runBareInit() {
        this.logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        this.getLogger().debug((Object)("------------- Test: " + this.getCurrentTestName()));
    }

    public void callBeginMethod(Request theRequest) throws Throwable {
        this.callGenericBeginMethod(theRequest, this.getBeginMethodName());
    }

    public Object callEndMethod(Request theRequest, ResponseObjectFactory theResponseFactory) throws Throwable {
        return this.callGenericEndMethod(theRequest, theResponseFactory, this.getEndMethodName(), null);
    }

    public void callGlobalBeginMethod(Request theRequest) throws Throwable {
        this.callGenericBeginMethod(theRequest, "begin");
    }

    private void callGlobalEndMethod(Request theRequest, ResponseObjectFactory theResponseFactory, Object theResponse) throws Throwable {
        this.callGenericEndMethod(theRequest, theResponseFactory, "end", theResponse);
    }

    private void setWrappedTest(Test theWrappedTest) {
        this.wrappedTest = theWrappedTest;
    }

    private void setDelegatedTest(Test theDelegatedTest) {
        this.delegatedTest = theDelegatedTest;
    }

    private Test getWrappedTest() {
        return this.wrappedTest;
    }

    private Test getDelegatedTest() {
        return this.delegatedTest;
    }

    private Test getTest() {
        Test activeTest = this.getWrappedTest() != null ? this.getWrappedTest() : this.getDelegatedTest();
        return activeTest;
    }

    private String getBaseMethodName() {
        if (!this.getCurrentTestName().startsWith(TEST_METHOD_PREFIX)) {
            throw new RuntimeException("bad name [" + this.getCurrentTestName() + "]. It should start with [" + TEST_METHOD_PREFIX + "].");
        }
        return this.getCurrentTestName().substring(TEST_METHOD_PREFIX.length());
    }

    private String getBeginMethodName() {
        return "begin" + this.getBaseMethodName();
    }

    private String getEndMethodName() {
        return "end" + this.getBaseMethodName();
    }

    private void callGenericBeginMethod(Request theRequest, String theMethodName) throws Throwable {
        Method[] methods = this.getTest().getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(theMethodName)) continue;
            TestCaseImplementChecker.checkAsBeginMethod(methods[i]);
            try {
                methods[i].invoke((Object)this.getTest(), theRequest);
                break;
            }
            catch (InvocationTargetException e) {
                e.fillInStackTrace();
                throw e.getTargetException();
            }
            catch (IllegalAccessException e) {
                e.fillInStackTrace();
                throw e;
            }
        }
    }

    private Object callGenericEndMethod(Request theRequest, ResponseObjectFactory theResponseFactory, String theMethodName, Object theResponse) throws Throwable {
        Method methodToCall = null;
        Object paramObject = null;
        Method[] methods = this.getTest().getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(theMethodName)) continue;
            TestCaseImplementChecker.checkAsEndMethod(methods[i]);
            paramObject = theResponse;
            if (paramObject == null) {
                Class<?>[] parameters = methods[i].getParameterTypes();
                try {
                    paramObject = theResponseFactory.getResponseObject(parameters[0].getName(), theRequest);
                }
                catch (ClientException e) {
                    throw new ClientException("The method [" + methods[i].getName() + "] has a bad parameter of type [" + parameters[0].getName() + "]", (Throwable)((Object)e));
                }
            }
            if (methodToCall != null) {
                ClientTestCaseCaller.fail((String)("There can only be one method [" + methods[i].getName() + "] per test case. " + "Test case [" + this.getCurrentTestName() + "] has two at least !"));
            }
            methodToCall = methods[i];
        }
        if (methodToCall != null) {
            try {
                methodToCall.invoke((Object)this.getTest(), paramObject);
            }
            catch (InvocationTargetException e) {
                e.fillInStackTrace();
                throw e.getTargetException();
            }
            catch (IllegalAccessException e) {
                e.fillInStackTrace();
                throw e;
            }
        }
        return paramObject;
    }

    private String getCurrentTestName() {
        return JUnitVersionHelper.getTestCaseName(this.getDelegatedTest());
    }
}

