/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.cactus.Request;
import org.apache.cactus.WebRequest;
import org.apache.cactus.WebResponse;
import org.apache.cactus.internal.client.ClientException;
import org.apache.cactus.spi.client.ResponseObjectFactory;

public class WebResponseObjectFactory
implements ResponseObjectFactory {
    private HttpURLConnection connection;

    public WebResponseObjectFactory(HttpURLConnection theConnection) {
        this.connection = theConnection;
    }

    /*
     * WARNING - void declaration
     */
    public Object getResponseObject(String theClassName, Request theRequest) throws ClientException {
        void var3_3;
        Object responseObject;
        if (theClassName.equals("com.meterware.httpunit.WebResponse")) {
            responseObject = this.createHttpUnitWebResponse(this.connection);
        } else if (theClassName.equals("com.gargoylesoftware.htmlunit.WebResponse")) {
            responseObject = this.createHtmlUnitWebResponse(this.connection);
        } else if (theClassName.equals("org.apache.cactus.WebResponse")) {
            responseObject = new WebResponse((WebRequest)theRequest, this.connection);
        } else if (theClassName.equals("java.net.HttpURLConnection")) {
            responseObject = this.connection;
        } else {
            throw new ClientException("Invalid parameter type [" + theClassName + "]");
        }
        return var3_3;
    }

    private Object createHttpUnitWebResponse(HttpURLConnection theConnection) throws ClientException {
        Object webResponse;
        try {
            Class<?> responseClass = Class.forName("com.meterware.httpunit.WebResponse");
            Method method = responseClass.getMethod("newResponse", URLConnection.class);
            webResponse = method.invoke(null, theConnection);
        }
        catch (Exception e) {
            throw new ClientException("Error calling [public static com.meterware.httpunit.WebResponse com.meterware.httpunit.WebResponse.newResponse(java.net.URLConnection) throws java.io.IOException]", e);
        }
        return webResponse;
    }

    private Object createHtmlUnitWebResponse(HttpURLConnection theConnection) throws ClientException {
        Object webResponse;
        try {
            Class<?> responseClass = Class.forName("com.gargoylesoftware.htmlunit.StringWebResponse");
            Constructor<?> method = responseClass.getConstructor(String.class, URL.class);
            InputStream input = theConnection.getInputStream();
            byte[] buffer = new byte[input.available()];
            input.read(buffer);
            webResponse = method.newInstance(new String(buffer), theConnection.getURL());
        }
        catch (Exception e) {
            throw new ClientException("Error calling [public static com.meterware.httpunit.WebResponse com.meterware.httpunit.WebResponse.newResponse(java.net.URLConnection) throws java.io.IOException]", e);
        }
        return webResponse;
    }
}

