/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client;

import org.apache.cactus.internal.WebTestResult;
import org.apache.cactus.internal.client.ParsingException;

public class WebTestResultParser {
    protected String exceptionClassname;
    protected String exceptionMessage;
    protected String exceptionStacktrace;

    public WebTestResult parse(String theData) throws ParsingException {
        WebTestResult result;
        String buffer = this.readRootElement(theData);
        if (buffer.length() == 0) {
            result = new WebTestResult();
        } else {
            buffer = this.readExceptionClassname(buffer);
            buffer = this.readExceptionMessage(buffer);
            buffer = this.readExceptionStacktrace(buffer);
            result = new WebTestResult(this.exceptionClassname, this.exceptionMessage, this.exceptionStacktrace);
        }
        return result;
    }

    protected String readRootElement(String theData) throws ParsingException {
        String startRootString = "<webresult>";
        String endRootString = "</webresult>";
        String trimmedData = theData.trim();
        if (!trimmedData.startsWith(startRootString) || !trimmedData.endsWith(endRootString)) {
            throw new ParsingException(this.formatError(theData));
        }
        String buffer = trimmedData.substring(startRootString.length(), trimmedData.length() - endRootString.length());
        return buffer;
    }

    protected String readExceptionClassname(String theData) throws ParsingException {
        String startString = "<exception classname=\"";
        String endString = "</exception>";
        if (!theData.startsWith(startString) || !theData.endsWith(endString)) {
            throw new ParsingException(this.formatError(theData));
        }
        int pos = theData.indexOf(34, startString.length());
        this.exceptionClassname = theData.substring(startString.length(), pos);
        String buffer = theData.substring(startString.length() + this.exceptionClassname.length() + 2, theData.length() - endString.length());
        return buffer;
    }

    protected String readExceptionMessage(String theData) throws ParsingException {
        String startString = "<message><![CDATA[";
        String endString = "]]></message>";
        if (!theData.startsWith(startString)) {
            throw new ParsingException(this.formatError(theData));
        }
        int pos = theData.indexOf(endString, startString.length());
        this.exceptionMessage = theData.substring(startString.length(), pos);
        String buffer = theData.substring(pos + endString.length());
        return buffer;
    }

    protected String readExceptionStacktrace(String theData) throws ParsingException {
        String startString = "<stacktrace><![CDATA[";
        String endString = "]]></stacktrace>";
        if (!theData.startsWith(startString)) {
            throw new ParsingException(this.formatError(theData));
        }
        int pos = theData.indexOf(endString, startString.length());
        this.exceptionStacktrace = theData.substring(startString.length(), pos);
        String buffer = theData.substring(pos + endString.length());
        return buffer;
    }

    private String formatError(String theData) {
        int nbChars = theData.length() > 100 ? 100 : theData.length();
        return "Not a valid response. First " + nbChars + " characters of the reponse: [" + theData.substring(0, nbChars) + "]";
    }
}

