/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client.connector.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class AutoReadHttpURLConnection
extends HttpURLConnection {
    private static final Log LOGGER = LogFactory.getLog((Class)AutoReadHttpURLConnection.class);
    private static final int DEFAULT_CHUNK_SIZE = 16384;
    private HttpURLConnection delegate;
    private InputStream streamBuffer;

    AutoReadHttpURLConnection(HttpURLConnection theConnection) {
        super(null);
        this.delegate = theConnection;
    }

    public synchronized InputStream getInputStream() throws IOException {
        try {
            if (this.streamBuffer == null) {
                LOGGER.debug((Object)("Original connection = " + this.delegate));
                InputStream is = this.delegate.getInputStream();
                this.streamBuffer = this.getBufferedInputStream(is);
            }
        }
        catch (IOException e) {
            this.logErrorStream(this.delegate.getErrorStream());
            throw e;
        }
        return this.streamBuffer;
    }

    private void logErrorStream(InputStream theErrorStream) throws IOException {
        if (theErrorStream != null) {
            String buffer;
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(theErrorStream));
            while ((buffer = errorStream.readLine()) != null) {
                LOGGER.debug((Object)("ErrorStream [" + buffer + "]"));
            }
        }
    }

    private InputStream getBufferedInputStream(InputStream theInputStream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(16384);
        this.copy(theInputStream, os);
        ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
        return bais;
    }

    private void copy(InputStream theInputStream, OutputStream theOutputStream) throws IOException {
        LOGGER.debug((Object)("Content-Length : [" + this.delegate.getContentLength() + "]"));
        if (theInputStream != null && this.delegate.getContentLength() != 0) {
            int count;
            byte[] buf = new byte[16384];
            while (-1 != (count = theInputStream.read(buf))) {
                this.printReadLogs(count, buf);
                theOutputStream.write(buf, 0, count);
            }
        }
    }

    private void printReadLogs(int theCount, byte[] theBuffer) {
        StringBuffer prefix = new StringBuffer();
        for (int i = 0; i < theCount; ++i) {
            if (theBuffer[i] == 10) {
                prefix.append("\\r");
                continue;
            }
            if (theBuffer[i] == 13) {
                prefix.append("\\n");
                continue;
            }
            prefix.append((char)theBuffer[i]);
        }
        LOGGER.debug((Object)("Read [" + theCount + "]: [" + prefix + "]"));
    }

    public void connect() throws IOException {
        this.delegate.connect();
    }

    public boolean getAllowUserInteraction() {
        return this.delegate.getAllowUserInteraction();
    }

    public Object getContent() throws IOException {
        return this.delegate.getContent();
    }

    public String getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    public int getContentLength() {
        return this.delegate.getContentLength();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public long getDate() {
        return this.delegate.getDate();
    }

    public boolean getDefaultUseCaches() {
        return this.delegate.getDefaultUseCaches();
    }

    public boolean getDoInput() {
        return this.delegate.getDoInput();
    }

    public boolean getDoOutput() {
        return this.delegate.getDoOutput();
    }

    public long getExpiration() {
        return this.delegate.getExpiration();
    }

    public String getHeaderField(int thePosition) {
        return this.delegate.getHeaderField(thePosition);
    }

    public String getHeaderField(String theName) {
        return this.delegate.getHeaderField(theName);
    }

    public long getHeaderFieldDate(String theName, long theDefaultValue) {
        return this.delegate.getHeaderFieldDate(theName, theDefaultValue);
    }

    public int getHeaderFieldInt(String theName, int theDefaultValue) {
        return this.delegate.getHeaderFieldInt(theName, theDefaultValue);
    }

    public String getHeaderFieldKey(int thePosition) {
        return this.delegate.getHeaderFieldKey(thePosition);
    }

    public long getIfModifiedSince() {
        return this.delegate.getIfModifiedSince();
    }

    public long getLastModified() {
        return this.delegate.getLastModified();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    public Permission getPermission() throws IOException {
        return this.delegate.getPermission();
    }

    public String getRequestProperty(String theKey) {
        return this.delegate.getRequestProperty(theKey);
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public boolean getUseCaches() {
        return this.delegate.getUseCaches();
    }

    public void setAllowUserInteraction(boolean hasInteraction) {
        this.delegate.setAllowUserInteraction(hasInteraction);
    }

    public void setDefaultUseCaches(boolean isUsingDefaultCache) {
        this.delegate.setDefaultUseCaches(isUsingDefaultCache);
    }

    public void setDoInput(boolean isInput) {
        this.delegate.setDoInput(isInput);
    }

    public void setDoOutput(boolean isOutput) {
        this.delegate.setDoOutput(isOutput);
    }

    public void setIfModifiedSince(long isModifiedSince) {
        this.delegate.setIfModifiedSince(isModifiedSince);
    }

    public void setRequestProperty(String theKey, String theValue) {
        this.delegate.setRequestProperty(theKey, theValue);
    }

    public void setUseCaches(boolean isUsingCaches) {
        this.delegate.setUseCaches(isUsingCaches);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void disconnect() {
        this.delegate.disconnect();
    }

    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    public String getRequestMethod() {
        return this.delegate.getRequestMethod();
    }

    public int getResponseCode() throws IOException {
        return this.delegate.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.delegate.getResponseMessage();
    }

    public void setRequestMethod(String theMethod) throws ProtocolException {
        this.delegate.setRequestMethod(theMethod);
    }

    public boolean usingProxy() {
        return this.delegate.usingProxy();
    }
}

