/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client.connector.http;

import java.net.HttpURLConnection;
import org.apache.cactus.WebRequest;
import org.apache.cactus.internal.RequestDirectives;
import org.apache.cactus.internal.ServiceEnumeration;
import org.apache.cactus.internal.WebRequestImpl;
import org.apache.cactus.internal.WebTestResult;
import org.apache.cactus.internal.client.AssertionFailedErrorWrapper;
import org.apache.cactus.internal.client.ParsingException;
import org.apache.cactus.internal.client.ServletExceptionWrapper;
import org.apache.cactus.internal.client.WebTestResultParser;
import org.apache.cactus.internal.client.connector.http.AutoReadHttpURLConnection;
import org.apache.cactus.internal.client.connector.http.HttpClientConnectionHelper;
import org.apache.cactus.internal.configuration.WebConfiguration;
import org.apache.cactus.internal.util.IoUtil;
import org.apache.cactus.util.ChainedRuntimeException;

public class DefaultHttpClient {
    protected WebConfiguration configuration;

    public DefaultHttpClient(WebConfiguration theConfiguration) {
        this.configuration = theConfiguration;
    }

    public HttpURLConnection doTest(WebRequest theRequest) throws Throwable {
        HttpURLConnection connection = this.callRunTest(theRequest);
        WebTestResult result = null;
        try {
            result = this.callGetResult(theRequest);
        }
        catch (ParsingException e) {
            String url = this.configuration.getRedirectorURL(theRequest);
            throw new ChainedRuntimeException("Failed to get the test results at [" + url + "]", (Throwable)((Object)e));
        }
        if (result.hasException()) {
            if (result.getExceptionClassName().equals("junit.framework.AssertionFailedError") || result.getExceptionClassName().equals("junit.framework.ComparisonFailure")) {
                throw new AssertionFailedErrorWrapper(result.getExceptionMessage(), result.getExceptionClassName(), result.getExceptionStackTrace());
            }
            throw new ServletExceptionWrapper(result.getExceptionMessage(), result.getExceptionClassName(), result.getExceptionStackTrace());
        }
        return connection;
    }

    private HttpURLConnection callRunTest(WebRequest theRequest) throws Throwable {
        theRequest.addParameter("Cactus_Service", ServiceEnumeration.CALL_TEST_SERVICE.toString(), "GET");
        HttpClientConnectionHelper helper = new HttpClientConnectionHelper(this.configuration.getRedirectorURL(theRequest));
        HttpURLConnection connection = helper.connect(theRequest, this.configuration);
        connection = new AutoReadHttpURLConnection(connection);
        connection.getInputStream();
        return connection;
    }

    private WebTestResult callGetResult(WebRequest theOriginalRequest) throws Throwable {
        HttpClientConnectionHelper helper;
        HttpURLConnection resultConnection;
        WebRequestImpl resultsRequest = new WebRequestImpl(this.configuration);
        RequestDirectives directives = new RequestDirectives(resultsRequest);
        directives.setService(ServiceEnumeration.GET_RESULTS_SERVICE);
        resultsRequest.setRedirectorName(theOriginalRequest.getRedirectorName());
        if (theOriginalRequest.getAuthentication() != null) {
            resultsRequest.setAuthentication(theOriginalRequest.getAuthentication());
        }
        if ((resultConnection = (helper = new HttpClientConnectionHelper(this.configuration.getRedirectorURL(resultsRequest))).connect(resultsRequest, this.configuration)).getResponseCode() != 200) {
            throw new ParsingException("Not a valid response [" + resultConnection.getResponseCode() + " " + resultConnection.getResponseMessage() + "]");
        }
        WebTestResultParser parser = new WebTestResultParser();
        return parser.parse(IoUtil.getText(resultConnection.getInputStream(), "UTF-8"));
    }
}

