/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client.connector.http;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.cactus.WebRequest;
import org.apache.cactus.client.authentication.Authentication;
import org.apache.cactus.internal.client.connector.http.ConnectionHelper;
import org.apache.cactus.internal.client.connector.http.HttpUtil;
import org.apache.cactus.internal.configuration.Configuration;
import org.apache.cactus.internal.util.CookieUtil;
import org.apache.cactus.internal.util.UrlUtil;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.HttpURLConnection;

public class HttpClientConnectionHelper
implements ConnectionHelper {
    private HttpMethod method;
    private String url;

    public HttpClientConnectionHelper(String theURL) {
        this.url = theURL;
    }

    public java.net.HttpURLConnection connect(WebRequest theRequest, Configuration theConfiguration) throws Throwable {
        URL url = new URL(this.url);
        HttpState state = new HttpState();
        this.method = theRequest.getParameterNamesPost().hasMoreElements() || theRequest.getUserData() != null ? new PostMethod() : new GetMethod();
        Authentication authentication = theRequest.getAuthentication();
        if (authentication != null) {
            authentication.configure(state, this.method, theRequest, theConfiguration);
        }
        url = HttpUtil.addHttpGetParameters(theRequest, url);
        this.method.setFollowRedirects(false);
        this.method.setPath(UrlUtil.getPath(url));
        this.method.setQueryString(UrlUtil.getQuery(url));
        this.method.setRequestHeader("Content-type", theRequest.getContentType());
        this.addHeaders(theRequest);
        if (theRequest.getUserData() != null) {
            this.addUserData(theRequest);
        } else {
            this.addHttpPostParameters(theRequest);
        }
        state.addCookies(CookieUtil.createHttpClientCookies(theRequest, url));
        HttpClient client = new HttpClient();
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(url.getHost(), url.getPort(), Protocol.getProtocol((String)url.getProtocol()));
        client.setState(state);
        client.executeMethod(hostConfiguration, this.method);
        return new HttpURLConnection(this.method, url);
    }

    private void addHttpPostParameters(WebRequest theRequest) {
        if (!theRequest.getParameterNamesPost().hasMoreElements()) {
            return;
        }
        Enumeration keys = theRequest.getParameterNamesPost();
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] values = theRequest.getParameterValuesPost(key);
            for (int i = 0; i < values.length; ++i) {
                parameters.add(new NameValuePair(key, values[i]));
            }
        }
        ((PostMethod)this.method).setRequestBody(parameters.toArray(new NameValuePair[parameters.size()]));
    }

    private void addHeaders(WebRequest theRequest) {
        Enumeration keys = theRequest.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] values = theRequest.getHeaderValues(key);
            StringBuffer fullHeaderValue = new StringBuffer(values[0]);
            for (int i = 1; i < values.length; ++i) {
                fullHeaderValue.append("," + values[i]);
            }
            this.method.addRequestHeader(key, fullHeaderValue.toString());
        }
    }

    private void addUserData(WebRequest theRequest) throws IOException {
        if (theRequest.getUserData() == null) {
            return;
        }
        ((PostMethod)this.method).setRequestBody(theRequest.getUserData());
    }
}

