/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client.connector.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import junit.framework.Test;
import org.apache.cactus.Request;
import org.apache.cactus.WebRequest;
import org.apache.cactus.internal.RequestDirectives;
import org.apache.cactus.internal.WebRequestImpl;
import org.apache.cactus.internal.client.WebResponseObjectFactory;
import org.apache.cactus.internal.client.connector.http.DefaultHttpClient;
import org.apache.cactus.internal.client.connector.http.HttpProtocolState;
import org.apache.cactus.internal.configuration.WebConfiguration;
import org.apache.cactus.internal.util.JUnitVersionHelper;
import org.apache.cactus.spi.client.ResponseObjectFactory;
import org.apache.cactus.spi.client.connector.ProtocolHandler;
import org.apache.cactus.spi.client.connector.ProtocolState;

public class HttpProtocolHandler
implements ProtocolHandler {
    private WebConfiguration configuration;

    public HttpProtocolHandler(WebConfiguration theConfiguration) {
        this.configuration = theConfiguration;
    }

    public Request createRequest() {
        return new WebRequestImpl(this.getConfiguration());
    }

    public ProtocolState runTest(Test theDelegatedTest, Test theWrappedTest, Request theRequest) throws Throwable {
        WebRequest request = (WebRequest)theRequest;
        HttpURLConnection connection = this.runWebTest(theDelegatedTest, theWrappedTest, request);
        HttpProtocolState state = new HttpProtocolState();
        state.setConnection(connection);
        return state;
    }

    public ResponseObjectFactory createResponseObjectFactory(ProtocolState theState) {
        HttpProtocolState state = (HttpProtocolState)theState;
        return new WebResponseObjectFactory(state.getConnection());
    }

    public void afterTest(ProtocolState theState) throws IOException {
        HttpProtocolState state = (HttpProtocolState)theState;
        state.getConnection().getInputStream().close();
    }

    private WebConfiguration getConfiguration() {
        return this.configuration;
    }

    private HttpURLConnection runWebTest(Test theDelegatedTest, Test theWrappedTest, WebRequest theRequest) throws Throwable {
        RequestDirectives directives = new RequestDirectives(theRequest);
        directives.setClassName(theDelegatedTest.getClass().getName());
        directives.setMethodName(this.getCurrentTestName(theDelegatedTest));
        directives.setAutoSession(theRequest.getAutomaticSession() ? "true" : "false");
        if (theWrappedTest != null) {
            directives.setWrappedTestName(theWrappedTest.getClass().getName());
        }
        if (theRequest.getURL() != null) {
            theRequest.getURL().saveToRequest(theRequest);
        }
        DefaultHttpClient client = new DefaultHttpClient(this.getConfiguration());
        HttpURLConnection connection = client.doTest(theRequest);
        return connection;
    }

    private String getCurrentTestName(Test theDelegatedTest) {
        return JUnitVersionHelper.getTestCaseName(theDelegatedTest);
    }
}

