/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.cactus.internal.util.ClassLoaderUtils;
import org.apache.cactus.util.ChainedRuntimeException;

public class ConfigurationInitializer {
    private static final String DEFAULT_CONFIG_NAME = "cactus";
    private static final String CACTUS_CONFIG_PROPERTY = "cactus.config";
    private static final String CACTUS_LOGGING_CONFIG_PROPERTY = "cactus.logging.config";
    private static boolean isInitialized;

    public static synchronized void initialize(boolean isReinitialization) {
        if (!isInitialized) {
            ConfigurationInitializer.initializeConfig(isReinitialization);
            ConfigurationInitializer.initializeLoggingConfig(isReinitialization);
            isInitialized = true;
        }
    }

    public static synchronized void initialize() {
        ConfigurationInitializer.initialize(false);
    }

    /*
     * WARNING - void declaration
     */
    private static void initializeConfig(boolean isReinitialization) {
        void var1_2;
        ResourceBundle config;
        String configOverride = System.getProperty(CACTUS_CONFIG_PROPERTY);
        if (configOverride == null) {
            try {
                config = ClassLoaderUtils.loadPropertyResourceBundle(DEFAULT_CONFIG_NAME, ConfigurationInitializer.class);
            }
            catch (MissingResourceException e) {
                return;
            }
        }
        try {
            config = new PropertyResourceBundle(new FileInputStream(configOverride));
        }
        catch (IOException e) {
            throw new ChainedRuntimeException("Cannot read cactus configuration file [" + configOverride + "]", (Throwable)e);
        }
        ConfigurationInitializer.addSystemProperties((ResourceBundle)var1_2, isReinitialization);
    }

    private static void initializeLoggingConfig(boolean isReinitialization) {
        String logConfig = System.getProperty(CACTUS_LOGGING_CONFIG_PROPERTY);
        if (logConfig != null) {
            PropertyResourceBundle bundle;
            try {
                bundle = new PropertyResourceBundle(new FileInputStream(logConfig));
            }
            catch (IOException e) {
                throw new ChainedRuntimeException("Failed to load logging configuration file [" + logConfig + "]");
            }
            ConfigurationInitializer.addSystemProperties(bundle, isReinitialization);
        }
    }

    private static void addSystemProperties(ResourceBundle theBundle, boolean isReinitialization) {
        Enumeration<String> keys = theBundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (System.getProperty(key) != null && !isReinitialization) continue;
            System.setProperty(key, theBundle.getString(key));
        }
    }
}

