/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.server;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cactus.internal.ServiceEnumeration;
import org.apache.cactus.internal.server.AbstractWebTestCaller;
import org.apache.cactus.internal.server.ServletUtil;
import org.apache.cactus.internal.server.WebImplicitObjects;
import org.apache.cactus.spi.server.ImplicitObjects;
import org.apache.cactus.spi.server.TestController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractWebTestController
implements TestController {
    private static final Log LOGGER = LogFactory.getLog((Class)AbstractWebTestController.class);

    protected abstract AbstractWebTestCaller getTestCaller(WebImplicitObjects var1);

    public void handleRequest(ImplicitObjects theObjects) throws ServletException {
        block8: {
            WebImplicitObjects webImplicitObjects = (WebImplicitObjects)theObjects;
            try {
                String serviceName = this.getServiceName(webImplicitObjects.getHttpServletRequest());
                AbstractWebTestCaller caller = this.getTestCaller(webImplicitObjects);
                ServiceEnumeration service = ServiceEnumeration.valueOf(serviceName);
                if (service == ServiceEnumeration.CALL_TEST_SERVICE) {
                    caller.doTest();
                    break block8;
                }
                if (service == ServiceEnumeration.GET_RESULTS_SERVICE) {
                    caller.doGetResults();
                    break block8;
                }
                if (service == ServiceEnumeration.RUN_TEST_SERVICE) {
                    caller.doRunTest();
                    break block8;
                }
                if (service == ServiceEnumeration.CREATE_SESSION_SERVICE) {
                    caller.doCreateSession();
                    break block8;
                }
                if (service == ServiceEnumeration.GET_VERSION_SERVICE) {
                    caller.doGetVersion();
                    break block8;
                }
                String message = "Unknown service [" + serviceName + "] in HTTP request.";
                LOGGER.error((Object)message);
                throw new ServletException(message);
            }
            catch (NoClassDefFoundError e) {
                if (e.getMessage().startsWith("junit/framework")) {
                    String message = "You must put the JUnit jar in your server classpath (in WEB-INF/lib for example)";
                    LOGGER.error((Object)message, (Throwable)e);
                    throw new ServletException(message, (Throwable)e);
                }
                String message = "You are missing a jar in your classpath (class [" + e.getMessage() + "] could not " + "be found";
                LOGGER.error((Object)message, (Throwable)e);
                throw new ServletException(message, (Throwable)e);
            }
        }
    }

    private String getServiceName(HttpServletRequest theRequest) throws ServletException {
        String queryString = theRequest.getQueryString();
        String serviceName = ServletUtil.getQueryStringParameter(queryString, "Cactus_Service");
        if (serviceName == null) {
            String message = "Missing service name parameter [Cactus_Service] in HTTP request. Received query string is [" + queryString + "].";
            LOGGER.debug((Object)message);
            throw new ServletException(message);
        }
        LOGGER.debug((Object)("Service to call = " + serviceName));
        return serviceName;
    }
}

