/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.server.runner;

import java.text.NumberFormat;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.cactus.internal.server.runner.XMLConstants;
import org.apache.cactus.internal.util.JUnitVersionHelper;
import org.apache.cactus.internal.util.StringUtil;

public class XMLFormatter
implements XMLConstants,
TestListener {
    private static final String[] DEFAULT_STACK_FILTER_PATTERNS = new String[]{"org.apache.cactus.AbstractTestCase", "org.apache.cactus.AbstractWebTestCase", "org.apache.cactus.FilterTestCase", "org.apache.cactus.JspTestCase", "org.apache.cactus.ServletTestCase", "junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "java.lang.reflect.Method.invoke("};
    private String xslFileName;
    private String suiteClassName;
    private long totalDuration;
    private String encoding = "UTF-8";
    private long currentTestStartTime;
    private NumberFormat durationFormat = NumberFormat.getInstance(Locale.US);
    private StringBuffer currentTestCaseResults = new StringBuffer();
    private String currentTestFailure;

    public void setXslFileName(String theXslFileName) {
        this.xslFileName = theXslFileName;
    }

    public void setEncoding(String theEncoding) {
        this.encoding = theEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSuiteClassName() {
        return this.suiteClassName;
    }

    public void setSuiteClassName(String theSuiteClassName) {
        this.suiteClassName = theSuiteClassName;
    }

    public String getTotalDurationAsString() {
        return this.getDurationAsString(this.totalDuration);
    }

    private String getDurationAsString(long theDuration) {
        return this.durationFormat.format((double)theDuration / 1000.0);
    }

    public void setTotalDuration(long theDuration) {
        this.totalDuration = theDuration;
    }

    public String toXML(TestResult theResult) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
        if (this.xslFileName != null) {
            xml.append("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.xslFileName + "\"?>");
        }
        xml.append("<testsuites>");
        xml.append("<testsuite name=\"" + this.getSuiteClassName() + "\" " + "tests" + "=\"" + theResult.runCount() + "\" " + "failures" + "=\"" + theResult.failureCount() + "\" " + "errors" + "=\"" + theResult.errorCount() + "\" " + "time" + "=\"" + this.getTotalDurationAsString() + "\">");
        xml.append(this.currentTestCaseResults.toString());
        xml.append("</testsuite>");
        xml.append("</testsuites>");
        return xml.toString();
    }

    public void startTest(Test theTest) {
        this.currentTestStartTime = System.currentTimeMillis();
        this.currentTestFailure = null;
    }

    public void addError(Test theTest, Throwable theThrowable) {
        TestFailure failure = new TestFailure(theTest, theThrowable);
        StringBuffer xml = new StringBuffer();
        xml.append("<error message=\"" + this.xmlEncode(failure.thrownException().getMessage()) + "\" " + "type" + "=\"" + failure.thrownException().getClass().getName() + "\">");
        xml.append(this.xmlEncode(StringUtil.exceptionToString(failure.thrownException(), DEFAULT_STACK_FILTER_PATTERNS)));
        xml.append("</error>");
        this.currentTestFailure = xml.toString();
    }

    public void addFailure(Test theTest, AssertionFailedError theError) {
        TestFailure failure = new TestFailure(theTest, (Throwable)theError);
        StringBuffer xml = new StringBuffer();
        xml.append("<failure message=\"" + this.xmlEncode(failure.thrownException().getMessage()) + "\" " + "type" + "=\"" + failure.thrownException().getClass().getName() + "\">");
        xml.append(this.xmlEncode(StringUtil.exceptionToString(failure.thrownException(), DEFAULT_STACK_FILTER_PATTERNS)));
        xml.append("</failure>");
        this.currentTestFailure = xml.toString();
    }

    public void endTest(Test theTest) {
        StringBuffer xml = new StringBuffer();
        String duration = this.getDurationAsString(System.currentTimeMillis() - this.currentTestStartTime);
        xml.append("<testcase name=\"" + JUnitVersionHelper.getTestCaseName(theTest) + "\" " + "time" + "=\"" + duration + "\">");
        if (this.currentTestFailure != null) {
            xml.append(this.currentTestFailure);
        }
        xml.append("</testcase>");
        this.currentTestCaseResults.append(xml.toString());
    }

    private String xmlEncode(String theString) {
        String newString = StringUtil.replace(theString, '&', "&amp;");
        newString = StringUtil.replace(newString, '<', "&lt;");
        newString = StringUtil.replace(newString, '>', "&gt;");
        newString = StringUtil.replace(newString, '\"', "&quot;");
        return newString;
    }
}

