/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.server.runner;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XMLTransformer {
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String HTML_OUTPUT_METHOD = "html";
    private static final String TEXT_MIME_TYPE = "text/plain";
    private static final String TEXT_OUTPUT_METHOD = "text";
    private static final String XML_MIME_TYPE = "text/xml";
    private static final String XSL_OUTPUT_PROPERTY_METHOD = "method";
    private Templates templates = null;
    private String contentType = "text/xml";

    public XMLTransformer(InputStream theStylesheet) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource source = new StreamSource(theStylesheet);
        this.templates = transformerFactory.newTemplates(source);
        String outputMethod = this.templates.getOutputProperties().getProperty(XSL_OUTPUT_PROPERTY_METHOD);
        this.contentType = this.getContentType(outputMethod);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void transform(Reader theXml, Writer theWriter) throws TransformerException {
        Transformer transformer = this.templates.newTransformer();
        transformer.transform(new StreamSource(theXml), new StreamResult(theWriter));
    }

    private String getContentType(String theOutputMethod) {
        String contentType = HTML_OUTPUT_METHOD.equals(theOutputMethod) ? HTML_MIME_TYPE : (TEXT_OUTPUT_METHOD.equals(theOutputMethod) ? TEXT_MIME_TYPE : XML_MIME_TYPE);
        return contentType;
    }
}

