/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ClassLoaderUtils {
    public static Class loadClass(String theClassName, Class theReferrer) throws ClassNotFoundException {
        Class clazz = null;
        try {
            clazz = ClassLoaderUtils.loadClassFromWebappClassLoader(theClassName, theReferrer);
        }
        catch (Throwable internalException) {
            clazz = ClassLoaderUtils.loadClassFromContextClassLoader(theClassName);
        }
        return clazz;
    }

    public static Class loadClassFromContextClassLoader(String theClassName) throws ClassNotFoundException {
        return Class.forName(theClassName, true, Thread.currentThread().getContextClassLoader());
    }

    public static Class loadClassFromWebappClassLoader(String theClassName, Class theReferrer) throws ClassNotFoundException {
        return Class.forName(theClassName, true, theReferrer.getClassLoader());
    }

    public static ResourceBundle loadPropertyResourceBundle(String theName, Class theReferrer) {
        ResourceBundle bundle;
        try {
            bundle = theReferrer.getClassLoader() == null ? PropertyResourceBundle.getBundle(theName, Locale.getDefault()) : PropertyResourceBundle.getBundle(theName, Locale.getDefault(), theReferrer.getClassLoader());
        }
        catch (MissingResourceException e) {
            bundle = PropertyResourceBundle.getBundle(theName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        return bundle;
    }
}

