/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.util;

import java.net.URL;
import java.util.Vector;
import org.apache.cactus.Cookie;
import org.apache.cactus.ServletURL;
import org.apache.cactus.WebRequest;
import org.apache.cactus.internal.client.ClientException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieUtil {
    private static final Log LOGGER = LogFactory.getLog((Class)CookieUtil.class);

    public static String getCookieDomain(WebRequest theRequest, String theRealHost) {
        ServletURL url = theRequest.getURL();
        String domain = url != null && url.getHost() != null ? url.getHost() : theRealHost;
        LOGGER.debug((Object)("Cookie validation domain = [" + domain + "]"));
        return domain;
    }

    public static int getCookiePort(WebRequest theRequest, int theRealPort) {
        ServletURL url = theRequest.getURL();
        int port = url != null && url.getHost() != null ? url.getPort() : theRealPort;
        LOGGER.debug((Object)("Cookie validation port = [" + port + "]"));
        return port;
    }

    public static String getCookiePath(WebRequest theRequest, String theRealPath) {
        int q;
        String file;
        ServletURL url = theRequest.getURL();
        String path = url != null && url.getPath() != null ? url.getPath() : ((file = theRealPath) != null ? ((q = file.lastIndexOf(63)) != -1 ? file.substring(0, q) : file) : null);
        LOGGER.debug((Object)("Cookie validation path = [" + path + "]"));
        return path;
    }

    public static org.apache.commons.httpclient.Cookie createHttpClientCookie(WebRequest theRequest, URL theUrl, Cookie theCactusCookie) {
        String domain = theCactusCookie.getDomain() == null ? CookieUtil.getCookieDomain(theRequest, theUrl.getHost()) : theCactusCookie.getDomain();
        String path = theCactusCookie.getPath() == null ? CookieUtil.getCookiePath(theRequest, theUrl.getFile()) : theCactusCookie.getPath();
        org.apache.commons.httpclient.Cookie httpclientCookie = new org.apache.commons.httpclient.Cookie(domain, theCactusCookie.getName(), theCactusCookie.getValue());
        httpclientCookie.setComment(theCactusCookie.getComment());
        httpclientCookie.setExpiryDate(theCactusCookie.getExpiryDate());
        httpclientCookie.setPath(path);
        httpclientCookie.setSecure(theCactusCookie.isSecure());
        return httpclientCookie;
    }

    public static org.apache.commons.httpclient.Cookie[] createHttpClientCookies(WebRequest theRequest, URL theUrl) {
        Vector cactusCookies = theRequest.getCookies();
        org.apache.commons.httpclient.Cookie[] httpclientCookies = new org.apache.commons.httpclient.Cookie[cactusCookies.size()];
        for (int i = 0; i < cactusCookies.size(); ++i) {
            Cookie cactusCookie = (Cookie)cactusCookies.elementAt(i);
            httpclientCookies[i] = CookieUtil.createHttpClientCookie(theRequest, theUrl, cactusCookie);
        }
        return httpclientCookies;
    }

    public static Header createCookieHeader(String theDomain, String thePath, org.apache.commons.httpclient.Cookie[] theCookies) throws ClientException {
        CookieSpec matcher;
        org.apache.commons.httpclient.Cookie[] cookies;
        Header cookieHeader = null;
        int port = 80;
        String host = theDomain;
        int portIndex = theDomain.indexOf(":");
        if (portIndex != -1) {
            host = host.substring(0, portIndex);
            port = Integer.parseInt(theDomain.substring(portIndex + 1));
        }
        if ((cookies = (matcher = CookiePolicy.getDefaultSpec()).match(host, port, thePath, false, theCookies)) != null && cookies.length > 0) {
            cookieHeader = matcher.formatCookieHeader(cookies);
        }
        if (cookieHeader == null) {
            throw new ClientException("Failed to create Cookie header for [domain = [" + theDomain + ", path = [" + thePath + ", cookies = [" + theCookies + "]]. Turn on HttpClient " + "logging for more information about the error");
        }
        return cookieHeader;
    }

    public static String getCookieString(WebRequest theRequest, URL theUrl) throws ClientException {
        Vector cookies = theRequest.getCookies();
        if (!cookies.isEmpty()) {
            org.apache.commons.httpclient.Cookie[] httpclientCookies = CookieUtil.createHttpClientCookies(theRequest, theUrl);
            Header cookieHeader = CookieUtil.createCookieHeader(CookieUtil.getCookieDomain(theRequest, theUrl.getHost()), CookieUtil.getCookiePath(theRequest, theUrl.getFile()), httpclientCookies);
            return cookieHeader.getValue();
        }
        return null;
    }
}

