/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

public class StringUtil {
    public static String exceptionToString(Throwable theThrowable) {
        return StringUtil.exceptionToString(theThrowable, null);
    }

    public static String exceptionToString(Throwable theThrowable, String[] theFilterPatterns) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        theThrowable.printStackTrace(pw);
        String stackTrace = sw.toString();
        return StringUtil.filterStackTrace(stackTrace, theFilterPatterns);
    }

    static String filterStackTrace(String theStackTrace, String[] theFilterPatterns) {
        if (theFilterPatterns == null || theFilterPatterns.length == 0 || theStackTrace == null) {
            return theStackTrace;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(theStackTrace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (StringUtil.filterLine(line, theFilterPatterns)) continue;
                printWriter.println(line);
            }
        }
        catch (IOException e) {
            return theStackTrace;
        }
        return stringWriter.toString();
    }

    public static boolean filterLine(String theLine, String[] theFilterPatterns) {
        for (int i = 0; i < theFilterPatterns.length; ++i) {
            if (theLine.indexOf(theFilterPatterns[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    public static String replace(String theBaseString, char theChar, String theNewString) {
        if (theBaseString == null) {
            return null;
        }
        int pos = theBaseString.indexOf(theChar);
        if (pos < 0) {
            return theBaseString;
        }
        int lastPos = 0;
        StringBuffer result = new StringBuffer();
        while (pos > -1) {
            result.append(theBaseString.substring(lastPos, pos));
            result.append(theNewString);
            lastPos = pos + 1;
            pos = theBaseString.indexOf(theChar, lastPos);
        }
        if (lastPos < theBaseString.length()) {
            result.append(theBaseString.substring(lastPos));
        }
        return result.toString();
    }
}

