/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import org.apache.cactus.Request;
import org.apache.cactus.internal.util.JUnitVersionHelper;
import org.apache.cactus.internal.util.TestCaseImplementError;

public final class TestCaseImplementChecker {
    private TestCaseImplementChecker() {
    }

    public static void checkTestName(Test theTest) throws TestCaseImplementError {
        if (theTest == null) {
            return;
        }
        if (JUnitVersionHelper.getTestCaseName(theTest) == null) {
            throw new TestCaseImplementError("No test name found. The test [" + theTest.getClass().getName() + "] is not properly implemented.");
        }
    }

    private static String numeric(int theNum) {
        switch (theNum) {
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
        }
        return theNum + "th";
    }

    private static void checkReturnType(Method theMethod, Class theType) throws TestCaseImplementError {
        if (!theMethod.getReturnType().equals(theType)) {
            throw new TestCaseImplementError("The method [" + theMethod.getName() + "] should return " + theType + " and not [" + theMethod.getReturnType().getName() + "]");
        }
    }

    private static void isPublic(Method theMethod) throws TestCaseImplementError {
        if (!Modifier.isPublic(theMethod.getModifiers())) {
            throw new TestCaseImplementError("The method [" + theMethod.getName() + "] should be declared public");
        }
    }

    private static void checkParameterCount(Method theMethod, Class[] theParams) throws TestCaseImplementError {
        Class<?>[] parameters = theMethod.getParameterTypes();
        if (parameters.length != theParams.length) {
            throw new TestCaseImplementError("The method [" + theMethod.getName() + "] must have " + theParams.length + " parameter(s), " + "but " + parameters.length + " parameter(s) were found");
        }
    }

    private static void checkParameterTypes(Method theMethod, Class[] theParams) throws TestCaseImplementError {
        TestCaseImplementChecker.checkParameterCount(theMethod, theParams);
        Class<?>[] parameters = theMethod.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            Class expected = theParams[i];
            Class<?> actual = parameters[i];
            if (expected.isAssignableFrom(actual)) continue;
            throw new TestCaseImplementError("The method [" + theMethod.getName() + "] must accept [" + expected.getName() + "] as " + TestCaseImplementChecker.numeric(i + 1) + " parameter, but found a [" + actual.getName() + "] parameter instead");
        }
    }

    private static void checkAsCactusMethod(Method theMethod) throws TestCaseImplementError {
        TestCaseImplementChecker.checkReturnType(theMethod, Void.TYPE);
        TestCaseImplementChecker.isPublic(theMethod);
    }

    public static void checkAsBeginMethod(Method theMethod) throws TestCaseImplementError {
        TestCaseImplementChecker.checkAsCactusMethod(theMethod);
        TestCaseImplementChecker.checkParameterTypes(theMethod, new Class[]{Request.class});
    }

    public static void checkAsEndMethod(Method theMethod) throws TestCaseImplementError {
        TestCaseImplementChecker.checkAsCactusMethod(theMethod);
        TestCaseImplementChecker.checkParameterCount(theMethod, new Class[]{Object.class});
    }
}

