/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.TestCase;

public class UniqueGenerator {
    private static byte count = 0;
    private static Object lock = new Object();
    private static String ipAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generate(TestCase theTestCase) {
        byte by;
        long time = System.currentTimeMillis();
        Object object = lock;
        synchronized (object) {
            by = count;
            count = (byte)(by + 1);
        }
        return UniqueGenerator.generate(theTestCase, time += (long)by);
    }

    public static String generate(TestCase theTestCase, long theTime) {
        String id = ipAddress;
        id = id + "-" + UniqueGenerator.toHex(theTime);
        id = id + "-" + UniqueGenerator.toHex(System.identityHashCode(theTestCase));
        id = id + UniqueGenerator.toHex(theTestCase.getName().hashCode());
        return id;
    }

    private static String toHex(long theValue) {
        return Long.toString(theValue, 16).toUpperCase();
    }

    static {
        try {
            byte[] ip = InetAddress.getLocalHost().getAddress();
            ipAddress = UniqueGenerator.toHex((ip[0] & 0xFF) << 24 | (ip[1] & 0xFF) << 16 | (ip[2] & 0xFF) << 8 | ip[3] & 0xFF);
        }
        catch (UnknownHostException e) {
            ipAddress = "";
        }
    }
}

