/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cactus.ServletURL;
import org.apache.cactus.server.RequestDispatcherWrapper;
import org.apache.cactus.util.ChainedRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHttpServletRequestWrapper
implements HttpServletRequest {
    private static final Log LOGGER = LogFactory.getLog((Class)AbstractHttpServletRequestWrapper.class);
    protected HttpServletRequest request;
    protected ServletURL url;
    protected String remoteIPAddress;
    protected String remoteHostName;
    protected String remoteUser;

    public AbstractHttpServletRequestWrapper(HttpServletRequest theRequest, ServletURL theURL) {
        this.request = theRequest;
        this.url = theURL;
    }

    public static AbstractHttpServletRequestWrapper newInstance(HttpServletRequest theOriginalRequest, ServletURL theURL) {
        try {
            Class<?> clazz = Class.forName("org.apache.cactus.server.HttpServletRequestWrapper");
            Object[] args = new Object[]{theOriginalRequest, theURL};
            Constructor<?> constructor = clazz.getConstructor(HttpServletRequest.class, ServletURL.class);
            return (AbstractHttpServletRequestWrapper)constructor.newInstance(args);
        }
        catch (Throwable t) {
            throw new ChainedRuntimeException("Failed to create HttpServletRequestWrapper", t);
        }
    }

    public HttpServletRequest getOriginalRequest() {
        return this.request;
    }

    public void setRemoteIPAddress(String theRemoteIPAddress) {
        this.remoteIPAddress = theRemoteIPAddress;
    }

    public void setRemoteHostName(String theRemoteHostName) {
        this.remoteHostName = theRemoteHostName;
    }

    public void setRemoteUser(String theRemoteUser) {
        this.remoteUser = theRemoteUser;
    }

    public String getContextPath() {
        String result = this.request.getContextPath();
        if (this.url != null && this.url.getContextPath() != null) {
            result = this.url.getContextPath();
            LOGGER.debug((Object)("Using simulated context : [" + result + "]"));
        }
        return result;
    }

    public String getPathInfo() {
        String result;
        if (this.url != null) {
            result = this.url.getPathInfo();
            LOGGER.debug((Object)("Using simulated PathInfo : [" + result + "]"));
        } else {
            result = this.request.getPathInfo();
        }
        return result;
    }

    public String getServerName() {
        String result = this.request.getServerName();
        if (this.url != null && this.url.getHost() != null) {
            result = this.url.getHost();
            LOGGER.debug((Object)("Using simulated server name : [" + result + "]"));
        }
        return result;
    }

    public int getServerPort() {
        int result = this.request.getServerPort();
        if (this.url != null && this.url.getServerName() != null) {
            result = this.url.getPort() == -1 ? 80 : this.url.getPort();
            LOGGER.debug((Object)("Using simulated server port : [" + result + "]"));
        }
        return result;
    }

    public String getRequestURI() {
        String result;
        if (this.url != null) {
            result = this.getContextPath() + (this.getServletPath() == null ? "" : this.getServletPath()) + (this.getPathInfo() == null ? "" : this.getPathInfo());
            LOGGER.debug((Object)("Using simulated request URI : [" + result + "]"));
        } else {
            result = this.request.getRequestURI();
        }
        return result;
    }

    public String getServletPath() {
        String result = this.request.getServletPath();
        if (this.url != null && this.url.getServletPath() != null) {
            result = this.url.getServletPath();
            LOGGER.debug((Object)("Using simulated servlet path : [" + result + "]"));
        }
        return result;
    }

    public String getPathTranslated() {
        String pathTranslated;
        if (this.url != null && this.url.getPathInfo() != null) {
            String pathInfo = this.url.getPathInfo();
            if (this.request.getRealPath("/") == null) {
                pathTranslated = null;
            } else {
                String newPathInfo;
                String string = newPathInfo = pathInfo.startsWith("/") ? pathInfo.substring(1) : pathInfo;
                pathTranslated = this.request.getRealPath("/").endsWith("/") ? this.request.getRealPath("/") + newPathInfo.replace('/', File.separatorChar) : this.request.getRealPath("/") + File.separatorChar + newPathInfo.replace('/', File.separatorChar);
            }
        } else {
            pathTranslated = this.request.getPathTranslated();
        }
        return pathTranslated;
    }

    public String getQueryString() {
        String result;
        if (this.url != null) {
            result = this.url.getQueryString();
            LOGGER.debug((Object)("Using simulated query string : [" + result + "]"));
        } else {
            result = this.request.getQueryString();
        }
        return result;
    }

    public RequestDispatcher getRequestDispatcher(String thePath) {
        String fullPath;
        if (thePath == null) {
            return null;
        }
        RequestDispatcherWrapper dispatcher = null;
        if (thePath.startsWith("/")) {
            fullPath = thePath;
        } else {
            String pI = this.getPathInfo();
            fullPath = pI == null ? this.catPath(this.getServletPath(), thePath) : this.catPath(this.getServletPath() + pI, thePath);
            if (fullPath == null) {
                return null;
            }
        }
        LOGGER.debug((Object)("Computed full path : [" + fullPath + "]"));
        dispatcher = new RequestDispatcherWrapper(this.request.getRequestDispatcher(fullPath));
        return dispatcher;
    }

    private String catPath(String theLookupPath, String thePath) {
        int index = theLookupPath.lastIndexOf("/");
        theLookupPath = theLookupPath.substring(0, index);
        while (thePath.startsWith("../")) {
            if (theLookupPath.length() <= 0) {
                return null;
            }
            index = theLookupPath.lastIndexOf("/");
            theLookupPath = theLookupPath.substring(0, index);
            index = thePath.indexOf("../") + 3;
            thePath = thePath.substring(index);
        }
        return theLookupPath + "/" + thePath;
    }

    public String getRemoteAddr() {
        String remoteIPAddress = this.remoteIPAddress != null ? this.remoteIPAddress : this.request.getRemoteAddr();
        return remoteIPAddress;
    }

    public String getRemoteHost() {
        String remoteHostName = this.remoteHostName != null ? this.remoteHostName : this.request.getRemoteHost();
        return remoteHostName;
    }

    public String getRemoteUser() {
        String remoteUser = this.remoteUser != null ? this.remoteUser : this.request.getRemoteUser();
        return remoteUser;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isUserInRole(String theRole) {
        return this.request.isUserInRole(theRole);
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public String getHeader(String theName) {
        return this.request.getHeader(theName);
    }

    public Enumeration getHeaders(String theName) {
        return this.request.getHeaders(theName);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getRealPath(String thePath) {
        return this.request.getRealPath(thePath);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean isCreate) {
        return this.request.getSession(isCreate);
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String[] getParameterValues(String theName) {
        return this.request.getParameterValues(theName);
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public void removeAttribute(String theName) {
        this.request.removeAttribute(theName);
    }

    public String getParameter(String theName) {
        return this.request.getParameter(theName);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public void setAttribute(String theName, Object theAttribute) {
        this.request.setAttribute(theName, theAttribute);
    }

    public Object getAttribute(String theName) {
        return this.request.getAttribute(theName);
    }

    public int getIntHeader(String theName) {
        return this.request.getIntHeader(theName);
    }

    public long getDateHeader(String theName) {
        return this.request.getDateHeader(theName);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }
}

