/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.cactus.ServletURL;
import org.apache.cactus.server.AbstractHttpServletRequestWrapper;
import org.apache.cactus.server.AbstractServletConfigWrapper;
import org.apache.cactus.server.AbstractServletContextWrapper;
import org.apache.cactus.util.ChainedRuntimeException;

public abstract class AbstractPageContextWrapper
extends PageContext {
    protected PageContext originalPageContext;
    protected ServletURL url;

    public AbstractPageContextWrapper(PageContext theOriginalPageContext, ServletURL theURL) {
        this.originalPageContext = theOriginalPageContext;
        this.url = theURL;
    }

    public static AbstractPageContextWrapper newInstance(PageContext theOriginalPageContext, ServletURL theServletURL) {
        try {
            Class<?> clazz = Class.forName("org.apache.cactus.server.PageContextWrapper");
            Object[] args = new Object[]{theOriginalPageContext, theServletURL};
            Constructor<?> constructor = clazz.getConstructor(PageContext.class, ServletURL.class);
            return (AbstractPageContextWrapper)((Object)constructor.newInstance(args));
        }
        catch (Throwable t) {
            throw new ChainedRuntimeException("Failed to create PageContextWrapper", t);
        }
    }

    public PageContext getOriginalPageContext() {
        return this.originalPageContext;
    }

    public ServletRequest getRequest() {
        return AbstractHttpServletRequestWrapper.newInstance((HttpServletRequest)this.originalPageContext.getRequest(), this.url);
    }

    public ServletConfig getServletConfig() {
        return AbstractServletConfigWrapper.newInstance(this.originalPageContext.getServletConfig());
    }

    public ServletContext getServletContext() {
        return AbstractServletContextWrapper.newInstance(this.originalPageContext.getServletContext());
    }

    public Object findAttribute(String theName) {
        return this.originalPageContext.findAttribute(theName);
    }

    public void forward(String theRelativeURLPath) throws ServletException, IOException {
        this.originalPageContext.forward(theRelativeURLPath);
    }

    public Object getAttribute(String theName) {
        return this.originalPageContext.getAttribute(theName);
    }

    public Object getAttribute(String theName, int theScope) {
        return this.originalPageContext.getAttribute(theName, theScope);
    }

    public Enumeration getAttributeNamesInScope(int theScope) {
        return this.originalPageContext.getAttributeNamesInScope(theScope);
    }

    public int getAttributesScope(String theName) {
        return this.originalPageContext.getAttributesScope(theName);
    }

    public Exception getException() {
        return this.originalPageContext.getException();
    }

    public JspWriter getOut() {
        return this.originalPageContext.getOut();
    }

    public Object getPage() {
        return this.originalPageContext.getPage();
    }

    public ServletResponse getResponse() {
        return this.originalPageContext.getResponse();
    }

    public HttpSession getSession() {
        return this.originalPageContext.getSession();
    }

    public void handlePageException(Exception theException) throws ServletException, IOException {
        this.originalPageContext.handlePageException(theException);
    }

    public void include(String theRelativeURLPath) throws ServletException, IOException {
        this.originalPageContext.include(theRelativeURLPath);
    }

    public void initialize(Servlet theServlet, ServletRequest theRequest, ServletResponse theResponse, String theErrorPageURL, boolean isSessionNeeded, int theBufferSize, boolean isAutoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        this.originalPageContext.initialize(theServlet, theRequest, theResponse, theErrorPageURL, isSessionNeeded, theBufferSize, isAutoFlush);
    }

    public JspWriter popBody() {
        return this.originalPageContext.popBody();
    }

    public BodyContent pushBody() {
        return this.originalPageContext.pushBody();
    }

    public void release() {
        this.originalPageContext.release();
    }

    public void removeAttribute(String theName) {
        this.originalPageContext.removeAttribute(theName);
    }

    public void removeAttribute(String theName, int theScope) {
        this.originalPageContext.removeAttribute(theName, theScope);
    }

    public void setAttribute(String theName, Object theAttribute) {
        this.originalPageContext.setAttribute(theName, theAttribute);
    }

    public void setAttribute(String theName, Object theAttribute, int theScope) {
        this.originalPageContext.setAttribute(theName, theAttribute, theScope);
    }
}

