/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.cactus.server.AbstractServletContextWrapper;
import org.apache.cactus.util.ChainedRuntimeException;

public abstract class AbstractServletConfigWrapper
implements ServletConfig {
    protected ServletConfig originalConfig;
    protected Hashtable initParameters;
    protected String servletName;

    public AbstractServletConfigWrapper(ServletConfig theOriginalConfig) {
        this.originalConfig = theOriginalConfig;
        this.initParameters = new Hashtable();
    }

    public static AbstractServletConfigWrapper newInstance(ServletConfig theOriginalConfig) {
        try {
            Class<?> clazz = Class.forName("org.apache.cactus.server.ServletConfigWrapper");
            Object[] args = new Object[]{theOriginalConfig};
            Constructor<?> constructor = clazz.getConstructor(ServletConfig.class);
            return (AbstractServletConfigWrapper)constructor.newInstance(args);
        }
        catch (Throwable t) {
            throw new ChainedRuntimeException("Failed to create ServletConfigWrapper", t);
        }
    }

    public void setInitParameter(String theName, String theValue) {
        this.initParameters.put(theName, theValue);
    }

    public void setServletName(String theServletName) {
        this.servletName = theServletName;
    }

    public ServletConfig getOriginalConfig() {
        return this.originalConfig;
    }

    public ServletContext getServletContext() {
        return AbstractServletContextWrapper.newInstance(this.originalConfig.getServletContext());
    }

    public String getInitParameter(String theName) {
        String value = (String)this.initParameters.get(theName);
        if (value == null) {
            value = this.originalConfig.getInitParameter(theName);
        }
        return value;
    }

    public Enumeration getInitParameterNames() {
        String value;
        Vector<String> names = new Vector<String>();
        Enumeration en = this.initParameters.keys();
        while (en.hasMoreElements()) {
            value = (String)en.nextElement();
            names.add(value);
        }
        en = this.originalConfig.getInitParameterNames();
        while (en.hasMoreElements()) {
            value = (String)en.nextElement();
            if (names.contains(value)) continue;
            names.add(value);
        }
        return names.elements();
    }

    public String getServletName() {
        if (this.servletName != null) {
            return this.servletName;
        }
        return this.originalConfig.getServletName();
    }
}

