/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cactus.server.RequestDispatcherWrapper;
import org.apache.cactus.util.ChainedRuntimeException;

public abstract class AbstractServletContextWrapper
implements ServletContext {
    protected ServletContext originalContext;
    protected Hashtable initParameters;
    private Vector logs = new Vector();

    public AbstractServletContextWrapper(ServletContext theOriginalContext) {
        this.originalContext = theOriginalContext;
        this.initParameters = new Hashtable();
    }

    public static AbstractServletContextWrapper newInstance(ServletContext theOriginalContext) {
        try {
            Class<?> clazz = Class.forName("org.apache.cactus.server.ServletContextWrapper");
            Object[] args = new Object[]{theOriginalContext};
            Constructor<?> constructor = clazz.getConstructor(ServletContext.class);
            return (AbstractServletContextWrapper)constructor.newInstance(args);
        }
        catch (Throwable t) {
            throw new ChainedRuntimeException("Failed to create ServletContextWrapper", t);
        }
    }

    public ServletContext getOriginalContext() {
        return this.originalContext;
    }

    public void setInitParameter(String theName, String theValue) {
        this.initParameters.put(theName, theValue);
    }

    public Vector getLogs() {
        return this.logs;
    }

    public void setAttribute(String theName, Object theAttribute) {
        this.originalContext.setAttribute(theName, theAttribute);
    }

    public void removeAttribute(String theName) {
        this.originalContext.removeAttribute(theName);
    }

    public void log(String theMessage, Throwable theCause) {
        if (theMessage != null) {
            this.logs.addElement(theMessage);
        }
        this.originalContext.log(theMessage, theCause);
    }

    public void log(String theMessage) {
        if (theMessage != null) {
            this.logs.addElement(theMessage);
        }
        this.originalContext.log(theMessage);
    }

    public void log(Exception theException, String theMessage) {
        if (theMessage != null) {
            this.logs.addElement(theMessage);
        }
        this.originalContext.log(theException, theMessage);
    }

    public Enumeration getServlets() {
        return this.originalContext.getServlets();
    }

    public Enumeration getServletNames() {
        return this.originalContext.getServletNames();
    }

    public Servlet getServlet(String theName) throws ServletException {
        return this.originalContext.getServlet(theName);
    }

    public String getServerInfo() {
        return this.originalContext.getServerInfo();
    }

    public InputStream getResourceAsStream(String thePath) {
        return this.originalContext.getResourceAsStream(thePath);
    }

    public URL getResource(String thePath) throws MalformedURLException {
        return this.originalContext.getResource(thePath);
    }

    public RequestDispatcher getRequestDispatcher(String thePath) {
        RequestDispatcherWrapper wrappedDispatcher = null;
        RequestDispatcher originalDispatcher = this.originalContext.getRequestDispatcher(thePath);
        if (originalDispatcher != null) {
            wrappedDispatcher = new RequestDispatcherWrapper(originalDispatcher);
        }
        return wrappedDispatcher;
    }

    public RequestDispatcher getNamedDispatcher(String theName) {
        RequestDispatcherWrapper wrappedDispatcher = null;
        RequestDispatcher originalDispatcher = this.originalContext.getNamedDispatcher(theName);
        if (originalDispatcher != null) {
            wrappedDispatcher = new RequestDispatcherWrapper(originalDispatcher);
        }
        return wrappedDispatcher;
    }

    public String getRealPath(String thePath) {
        return this.originalContext.getRealPath(thePath);
    }

    public int getMinorVersion() {
        return this.originalContext.getMinorVersion();
    }

    public String getMimeType(String theFilename) {
        return this.originalContext.getMimeType(theFilename);
    }

    public int getMajorVersion() {
        return this.originalContext.getMajorVersion();
    }

    public Enumeration getInitParameterNames() {
        String value;
        Vector<String> names = new Vector<String>();
        Enumeration en = this.initParameters.keys();
        while (en.hasMoreElements()) {
            value = (String)en.nextElement();
            names.add(value);
        }
        en = this.originalContext.getInitParameterNames();
        while (en.hasMoreElements()) {
            value = (String)en.nextElement();
            if (names.contains(value)) continue;
            names.add(value);
        }
        return names.elements();
    }

    public String getInitParameter(String theName) {
        String value = (String)this.initParameters.get(theName);
        if (value == null) {
            value = this.originalContext.getInitParameter(theName);
        }
        return value;
    }

    public ServletContext getContext(String theUripath) {
        AbstractServletContextWrapper context = AbstractServletContextWrapper.newInstance(this.originalContext.getContext(theUripath));
        return context;
    }

    public Enumeration getAttributeNames() {
        return this.originalContext.getAttributeNames();
    }

    public Object getAttribute(String theName) {
        return this.originalContext.getAttribute(theName);
    }
}

