/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server.runner;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.cactus.internal.configuration.ConfigurationInitializer;
import org.apache.cactus.internal.server.runner.WebappTestRunner;
import org.apache.cactus.internal.server.runner.XMLFormatter;

public class ServletTestRunner
extends HttpServlet {
    private static final String HTTP_SUITE_PARAM = "suite";
    private static final String HTTP_TRANSFORM_PARAM = "transform";
    private static final String HTTP_XSL_PARAM = "xsl";
    private static final String XSL_STYLESHEET_PARAM = "xsl-stylesheet";
    private static final String ENCODING_PARAM = "encoding";
    private Object transformer = null;
    private boolean canSetSystemProperty = true;

    public void init() throws ServletException {
        ConfigurationInitializer.initialize(true);
        String xslStylesheetParam = this.getInitParameter(XSL_STYLESHEET_PARAM);
        if (xslStylesheetParam != null) {
            InputStream xslStylesheet = this.getServletContext().getResourceAsStream(xslStylesheetParam);
            if (xslStylesheet != null) {
                try {
                    Class<?> transformerClass = Class.forName("org.apache.cactus.internal.server.runner.XMLTransformer");
                    Constructor<?> transformerCtor = transformerClass.getConstructor(InputStream.class);
                    this.transformer = transformerCtor.newInstance(xslStylesheet);
                }
                catch (Throwable t) {
                    this.log("Could not instantiate XMLTransformer - will not perform server-side XSLT transformations", t);
                }
            } else {
                throw new UnavailableException("The initialization parameter 'xsl-stylesheet' does not refer to an existing resource");
            }
        }
    }

    public void doGet(HttpServletRequest theRequest, HttpServletResponse theResponse) throws ServletException, IOException {
        String suiteClassName = theRequest.getParameter(HTTP_SUITE_PARAM);
        this.setSystemProperties(theRequest);
        if (suiteClassName == null) {
            throw new ServletException("Missing HTTP parameter [suite] in request");
        }
        String xslParam = theRequest.getParameter(HTTP_XSL_PARAM);
        String transformParam = theRequest.getParameter(HTTP_TRANSFORM_PARAM);
        String encoding = theRequest.getParameter(ENCODING_PARAM);
        String xml = this.run(suiteClassName, xslParam, encoding);
        if (transformParam != null && this.transformer != null) {
            try {
                Method getContentTypeMethod = this.transformer.getClass().getMethod("getContentType", new Class[0]);
                theResponse.setContentType((String)getContentTypeMethod.invoke(this.transformer, new Object[0]));
                PrintWriter out = theResponse.getWriter();
                Method transformMethod = this.transformer.getClass().getMethod(HTTP_TRANSFORM_PARAM, Reader.class, Writer.class);
                transformMethod.invoke(this.transformer, new StringReader(xml), out);
            }
            catch (Exception e) {
                throw new ServletException("Problem applying the XSLT transformation", (Throwable)e);
            }
        } else {
            theResponse.setContentType("text/xml");
            PrintWriter pw = theResponse.getWriter();
            pw.println(xml);
        }
    }

    private void setSystemProperties(HttpServletRequest theRequest) {
        String contextURL = System.getProperty("cactus.contextURL");
        if (contextURL == null && this.canSetSystemProperty) {
            try {
                System.setProperty("cactus.contextURL", "http://" + theRequest.getServerName() + ":" + theRequest.getServerPort() + theRequest.getContextPath());
            }
            catch (SecurityException se) {
                this.log("Could not set the Cactus context URL as system property, you will have to include a Cactus properties file in the class path of the web application", se);
                this.canSetSystemProperty = false;
            }
        }
    }

    protected String run(String theSuiteClassName, String theXslFileName, String theEncoding) throws ServletException {
        TestResult result = new TestResult();
        XMLFormatter formatter = new XMLFormatter();
        formatter.setXslFileName(theXslFileName);
        formatter.setSuiteClassName(theSuiteClassName);
        if (theEncoding != null) {
            formatter.setEncoding(theEncoding);
        }
        result.addListener((TestListener)formatter);
        long startTime = System.currentTimeMillis();
        WebappTestRunner testRunner = new WebappTestRunner();
        Test suite = testRunner.getTest(theSuiteClassName);
        if (suite == null) {
            throw new ServletException("Failed to load test suite [" + theSuiteClassName + "], Reason is [" + testRunner.getErrorMessage() + "]");
        }
        suite.run(result);
        long endTime = System.currentTimeMillis();
        formatter.setTotalDuration(endTime - startTime);
        return formatter.toXML(result);
    }
}

