/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.server.runner;

import java.text.NumberFormat;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.cactus.internal.server.runner.XMLConstants;
import org.apache.cactus.internal.util.JUnitVersionHelper;
import org.apache.cactus.internal.util.StringUtil;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class XMLFormatter
implements XMLConstants,
TestListener {
    private static final String[] DEFAULT_STACK_FILTER_PATTERNS;
    private String xslFileName;
    private String suiteClassName;
    private long totalDuration;
    private String encoding = "UTF-8";
    private long currentTestStartTime;
    private NumberFormat durationFormat = NumberFormat.getInstance(Locale.US);
    private StringBuffer currentTestCaseResults = new StringBuffer();
    private String currentTestFailure;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        Factory factory = new Factory("XMLFormatter.java", Class.forName("org.apache.cactus.internal.server.runner.XMLFormatter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setXslFileName-org.apache.cactus.internal.server.runner.XMLFormatter-java.lang.String:-theXslFileName:--void-"), 110);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setEncoding-org.apache.cactus.internal.server.runner.XMLFormatter-java.lang.String:-theEncoding:--void-"), 118);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setSuiteClassName-org.apache.cactus.internal.server.runner.XMLFormatter-java.lang.String:-theSuiteClassName:--void-"), 144);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setTotalDuration-org.apache.cactus.internal.server.runner.XMLFormatter-long:-theDuration:--void-"), 173);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toXML-org.apache.cactus.internal.server.runner.XMLFormatter-junit.framework.TestResult:-theResult:--java.lang.String-"), 184);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-startTest-org.apache.cactus.internal.server.runner.XMLFormatter-junit.framework.Test:-theTest:--void-"), 219);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-addError-org.apache.cactus.internal.server.runner.XMLFormatter-junit.framework.Test:java.lang.Throwable:-theTest:theThrowable:--void-"), 231);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-addFailure-org.apache.cactus.internal.server.runner.XMLFormatter-junit.framework.Test:junit.framework.AssertionFailedError:-theTest:theError:--void-"), 253);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-endTest-org.apache.cactus.internal.server.runner.XMLFormatter-junit.framework.Test:-theTest:--void-"), 274);
        DEFAULT_STACK_FILTER_PATTERNS = new String[]{"org.apache.cactus.AbstractTestCase", "org.apache.cactus.AbstractWebTestCase", "org.apache.cactus.FilterTestCase", "org.apache.cactus.JspTestCase", "org.apache.cactus.ServletTestCase", "junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "java.lang.reflect.Method.invoke("};
    }

    public void setXslFileName(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
        XMLFormatter.setXslFileName_aroundBody1$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void setEncoding(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2);
        XMLFormatter.setEncoding_aroundBody3$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSuiteClassName() {
        return this.suiteClassName;
    }

    public void setSuiteClassName(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
        XMLFormatter.setSuiteClassName_aroundBody5$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getTotalDurationAsString() {
        return this.getDurationAsString(this.totalDuration);
    }

    private String getDurationAsString(long theDuration) {
        return this.durationFormat.format((double)theDuration / 1000.0);
    }

    public void setTotalDuration(long l) {
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        XMLFormatter.setTotalDuration_aroundBody7$advice(this, l2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String toXML(TestResult testResult) {
        TestResult testResult2 = testResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)testResult2);
        return (String)XMLFormatter.toXML_aroundBody9$advice(this, testResult2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void startTest(Test test) {
        Test test2 = test;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)test2);
        XMLFormatter.startTest_aroundBody11$advice(this, test2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void addError(Test test, Throwable throwable) {
        Test test2 = test;
        Throwable throwable2 = throwable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)test2, (Object)throwable2);
        XMLFormatter.addError_aroundBody13$advice(this, test2, throwable2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        Test test2 = test;
        AssertionFailedError assertionFailedError2 = assertionFailedError;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)test2, (Object)assertionFailedError2);
        XMLFormatter.addFailure_aroundBody15$advice(this, test2, assertionFailedError2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void endTest(Test test) {
        Test test2 = test;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)test2);
        XMLFormatter.endTest_aroundBody17$advice(this, test2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private String xmlEncode(String theString) {
        String newString = StringUtil.replace(theString, '&', "&amp;");
        newString = StringUtil.replace(newString, '<', "&lt;");
        newString = StringUtil.replace(newString, '>', "&gt;");
        newString = StringUtil.replace(newString, '\"', "&quot;");
        return newString;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object setXslFileName_aroundBody1$advice(XMLFormatter this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            this_.xslFileName = ajc_aroundClosure;
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        this_.xslFileName = ajc_aroundClosure;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object setEncoding_aroundBody3$advice(XMLFormatter this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            this_.encoding = ajc_aroundClosure;
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        this_.encoding = ajc_aroundClosure;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object setSuiteClassName_aroundBody5$advice(XMLFormatter this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            this_.suiteClassName = ajc_aroundClosure;
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        this_.suiteClassName = ajc_aroundClosure;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object setTotalDuration_aroundBody7$advice(XMLFormatter this_, long ajc_aroundClosure, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            this_.totalDuration = ajc_aroundClosure;
            Object var9_9 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_9;
        }
        AroundClosure aroundClosure3 = aroundClosure;
        this_.totalDuration = ajc_aroundClosure;
        return null;
    }

    private static final /* synthetic */ String toXML_aroundBody8(XMLFormatter this_, TestResult theResult, JoinPoint joinPoint) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"" + this_.getEncoding() + "\"?>");
        if (this_.xslFileName != null) {
            xml.append("<?xml-stylesheet type=\"text/xsl\" href=\"" + this_.xslFileName + "\"?>");
        }
        xml.append("<testsuites>");
        xml.append("<testsuite name=\"" + this_.getSuiteClassName() + "\" " + "tests" + "=\"" + theResult.runCount() + "\" " + "failures" + "=\"" + theResult.failureCount() + "\" " + "errors" + "=\"" + theResult.errorCount() + "\" " + "time" + "=\"" + this_.getTotalDurationAsString() + "\">");
        xml.append(this_.currentTestCaseResults.toString());
        xml.append("</testsuite>");
        xml.append("</testsuites>");
        return xml.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object toXML_aroundBody9$advice(XMLFormatter this_, TestResult ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var10_8 = logger;
            String string = XMLFormatter.toXML_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append((Object)string);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return string;
        }
        void var11_11 = logger;
        return XMLFormatter.toXML_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
    }

    private static final /* synthetic */ void startTest_aroundBody10(XMLFormatter this_, Test theTest, JoinPoint joinPoint) {
        this_.currentTestStartTime = System.currentTimeMillis();
        this_.currentTestFailure = null;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object startTest_aroundBody11$advice(XMLFormatter this_, Test ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.startTest_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.startTest_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final /* synthetic */ void addError_aroundBody12(XMLFormatter this_, Test theTest, Throwable theThrowable, JoinPoint joinPoint) {
        TestFailure failure = new TestFailure(theTest, theThrowable);
        StringBuffer xml = new StringBuffer();
        xml.append("<error message=\"" + this_.xmlEncode(failure.thrownException().getMessage()) + "\" " + "type" + "=\"" + failure.thrownException().getClass().getName() + "\">");
        xml.append(this_.xmlEncode(StringUtil.exceptionToString(failure.thrownException(), DEFAULT_STACK_FILTER_PATTERNS)));
        xml.append("</error>");
        this_.currentTestFailure = xml.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object addError_aroundBody13$advice(XMLFormatter this_, Test ajc_aroundClosure, Throwable thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            XMLFormatter.addError_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        AroundClosure aroundClosure3 = aroundClosure;
        XMLFormatter.addError_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }

    private static final /* synthetic */ void addFailure_aroundBody14(XMLFormatter this_, Test theTest, AssertionFailedError theError, JoinPoint joinPoint) {
        TestFailure failure = new TestFailure(theTest, (Throwable)theError);
        StringBuffer xml = new StringBuffer();
        xml.append("<failure message=\"" + this_.xmlEncode(failure.thrownException().getMessage()) + "\" " + "type" + "=\"" + failure.thrownException().getClass().getName() + "\">");
        xml.append(this_.xmlEncode(StringUtil.exceptionToString(failure.thrownException(), DEFAULT_STACK_FILTER_PATTERNS)));
        xml.append("</failure>");
        this_.currentTestFailure = xml.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object addFailure_aroundBody15$advice(XMLFormatter this_, Test ajc_aroundClosure, AssertionFailedError thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            XMLFormatter.addFailure_aroundBody14(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        AroundClosure aroundClosure3 = aroundClosure;
        XMLFormatter.addFailure_aroundBody14(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }

    private static final /* synthetic */ void endTest_aroundBody16(XMLFormatter this_, Test theTest, JoinPoint joinPoint) {
        StringBuffer xml = new StringBuffer();
        String duration = this_.getDurationAsString(System.currentTimeMillis() - this_.currentTestStartTime);
        xml.append("<testcase name=\"" + JUnitVersionHelper.getTestCaseName(theTest) + "\" " + "time" + "=\"" + duration + "\">");
        if (this_.currentTestFailure != null) {
            xml.append(this_.currentTestFailure);
        }
        xml.append("</testcase>");
        this_.currentTestCaseResults.append(xml.toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object endTest_aroundBody17$advice(XMLFormatter this_, Test ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.endTest_aroundBody16(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.endTest_aroundBody16(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }
}

