/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.api.cactify;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlUtils;
import org.codehaus.cargo.util.log.Logger;

public abstract class Redirector {
    protected Logger logger;
    protected String name;
    protected String mapping;
    protected String roles;

    public Redirector() {
    }

    public Redirector(Logger logger) {
        this.logger = logger;
    }

    public abstract void mergeInto(WebXml var1);

    public final void setName(String theName) {
        this.name = theName;
    }

    public final void setMapping(String theMapping) {
        this.mapping = theMapping;
    }

    public final void setRoles(String theRoles) {
        this.roles = theRoles;
    }

    protected final void addSecurity(WebXml theWebXml) {
        StringTokenizer tokenizer = new StringTokenizer(this.roles, ",");
        ArrayList<String> roles = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String role = tokenizer.nextToken().trim();
            if (!WebXmlUtils.hasSecurityRole((WebXml)theWebXml, (String)role)) {
                WebXmlUtils.addSecurityRole((WebXml)theWebXml, (String)role);
            }
            roles.add(role);
        }
        if (!roles.isEmpty()) {
            if (!WebXmlUtils.hasLoginConfig((WebXml)theWebXml)) {
                WebXmlUtils.setLoginConfig((WebXml)theWebXml, (String)"BASIC", (String)"myrealm");
            }
            if (!WebXmlUtils.hasSecurityConstraint((WebXml)theWebXml, (String)this.mapping)) {
                WebXmlUtils.addSecurityConstraint((WebXml)theWebXml, (String)"Cactus Test Redirector", (String)this.mapping, roles);
            }
        }
    }
}

