/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.api.deployable;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cactus.integration.api.deployable.EarDeployableFile;
import org.apache.cactus.integration.api.deployable.WarParser;
import org.apache.cactus.integration.api.exceptions.CactusRuntimeException;
import org.codehaus.cargo.module.application.ApplicationXml;
import org.codehaus.cargo.module.application.DefaultEarArchive;
import org.codehaus.cargo.module.application.EarArchive;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public class EarParser {
    public static final EarDeployableFile parse(File theDeployableFile) {
        EarDeployableFile deployable = new EarDeployableFile();
        try {
            deployable.setFile(theDeployableFile);
            DefaultEarArchive earArchive = new DefaultEarArchive((InputStream)new FileInputStream(theDeployableFile));
            String webUri = EarParser.getUriOfCactifiedWebModule((EarArchive)earArchive);
            if (webUri == null) {
                throw new CactusRuntimeException("Could not find cactified web module in the [" + theDeployableFile + "] EAR.");
            }
            WarArchive warArchive = earArchive.getWebModule(webUri);
            if (warArchive == null) {
                throw new CactusRuntimeException("Could not find the WAR [" + webUri + "] in the [" + theDeployableFile + "] EAR.");
            }
            deployable.setWarArchive(warArchive);
            deployable.setTestContext(EarParser.parseTestContext((EarArchive)earArchive, webUri));
            deployable.setServletRedirectorMapping(WarParser.parseServletRedirectorMapping(deployable.getWarArchive()));
            deployable.setFilterRedirectorMapping(WarParser.parseFilterRedirectorMapping(deployable.getWarArchive()));
            deployable.setJspRedirectorMapping(WarParser.parseJspRedirectorMapping(deployable.getWarArchive()));
        }
        catch (IOException e) {
            throw new CactusRuntimeException("Failed to parse deployment descriptor for EAR file [" + theDeployableFile + "].", e);
        }
        catch (ParserConfigurationException e) {
            throw new CactusRuntimeException("Failed to parse deployment descriptor for EAR file [" + theDeployableFile + "].", e);
        }
        catch (SAXException e) {
            throw new CactusRuntimeException("Failed to parse deployment descriptor for EAR file [" + theDeployableFile + "].", e);
        }
        catch (JDOMException e) {
            throw new CactusRuntimeException("Failed to parse deployment descriptor for EAR file [" + theDeployableFile + "].", (Exception)((Object)e));
        }
        return deployable;
    }

    public static final String parseTestContext(EarArchive theEar, String theWebUri) throws ParserConfigurationException, IOException, SAXException, JDOMException {
        String context = theEar.getApplicationXml().getWebModuleContextRoot(theWebUri);
        if (context == null) {
            throw new CactusRuntimeException("Your application.xml must define a <context-root> element in the <web> module definition.");
        }
        if (context.startsWith("/")) {
            context = context.substring(1);
        }
        return context;
    }

    protected static final String getUriOfCactifiedWebModule(EarArchive theEar) throws SAXException, IOException, ParserConfigurationException, JDOMException {
        ApplicationXml applicationXml = theEar.getApplicationXml();
        Iterator i = applicationXml.getWebModuleUris();
        while (i.hasNext()) {
            String webUri = (String)i.next();
            WarArchive war = theEar.getWebModule(webUri);
            if (war == null || WarParser.parseServletRedirectorMapping(war) == null) continue;
            return webUri;
        }
        return null;
    }
}

