/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.util.function.Supplier;
import org.apache.camel.quarkus.core.CamelRuntime;
import org.jboss.logging.Logger;

@Recorder
public class CamelBootstrapRecorder {
    public void addShutdownTask(ShutdownContext shutdown, final RuntimeValue<CamelRuntime> runtime) {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                try {
                    ((CamelRuntime)runtime.getValue()).stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void start(RuntimeValue<CamelRuntime> runtime, Supplier<String[]> arguments) {
        try {
            Logger logger = Logger.getLogger(CamelBootstrapRecorder.class);
            logger.infof("Bootstrap runtime: %s", (Object)((CamelRuntime)runtime.getValue()).getClass().getName());
            ((CamelRuntime)runtime.getValue()).start(arguments.get());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

