/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.Component;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.microprofile.config.CamelMicroProfilePropertiesSource;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultShutdownStrategy;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.quarkus.CamelQuarkusBeanPostProcessor;
import org.apache.camel.quarkus.core.CamelQuarkusClassResolver;
import org.apache.camel.quarkus.core.CamelQuarkusPackageScanResourceResolver;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentNameResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.ModelToYAMLDumper;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.util.IOHelper;

public class FastCamelContext
extends DefaultCamelContext
implements CatalogCamelContext,
ModelCamelContext {
    private final String version;
    private final ModelToXMLDumper xmlModelDumper;
    private final ModelToYAMLDumper yamlModelDumper;

    public FastCamelContext(String version, ModelToXMLDumper xmlModelDumper, ModelToYAMLDumper yamlModelDumper) {
        super(false);
        this.version = version;
        this.xmlModelDumper = xmlModelDumper;
        this.yamlModelDumper = yamlModelDumper;
    }

    public void build() {
        super.build();
        this.resetBuildTime();
    }

    public String getVersion() {
        return this.version;
    }

    protected Registry createRegistry() {
        throw new UnsupportedOperationException("In case that the test based on CamelQuarkusTestSupport throws this exception, be aware that re-starting of context is not possible.");
    }

    protected ManagementNameStrategy createManagementNameStrategy() {
        return null;
    }

    protected ShutdownStrategy createShutdownStrategy() {
        return new DefaultShutdownStrategy();
    }

    protected ComponentResolver createComponentResolver() {
        return (name, context) -> (Component)context.getRegistry().lookupByNameAndType(name, Component.class);
    }

    protected ComponentNameResolver createComponentNameResolver() {
        return null;
    }

    protected ModelReifierFactory createModelReifierFactory() {
        return null;
    }

    ModelReifierFactory createDefaultModelReifierFactory() {
        return super.createModelReifierFactory();
    }

    protected boolean eagerCreateTypeConverter() {
        return false;
    }

    protected TypeConverter createTypeConverter() {
        throw new UnsupportedOperationException();
    }

    protected TypeConverterRegistry createTypeConverterRegistry() {
        return null;
    }

    protected CamelBeanPostProcessor createBeanPostProcessor() {
        return new CamelQuarkusBeanPostProcessor((CamelContext)this);
    }

    protected ModelJAXBContextFactory createModelJAXBContextFactory() {
        return null;
    }

    protected FactoryFinderResolver createFactoryFinderResolver() {
        return null;
    }

    protected ClassResolver createClassResolver() {
        return new CamelQuarkusClassResolver(Objects.requireNonNull(this.getApplicationContextClassLoader(), "applicationContextClassLoader must be set before calling createClassResolver()"));
    }

    protected PropertiesComponent createPropertiesComponent() {
        org.apache.camel.component.properties.PropertiesComponent pc = new org.apache.camel.component.properties.PropertiesComponent();
        pc.setAutoDiscoverPropertiesSources(true);
        pc.addPropertiesSource((PropertiesSource)new CamelMicroProfilePropertiesSource());
        return pc;
    }

    protected ModelToXMLDumper createModelToXMLDumper() {
        return this.xmlModelDumper;
    }

    protected ModelToYAMLDumper createModelToYAMLDumper() {
        return this.yamlModelDumper;
    }

    protected PackageScanResourceResolver createPackageScanResourceResolver() {
        return new CamelQuarkusPackageScanResourceResolver();
    }

    protected VariableRepositoryFactory createVariableRepositoryFactory() {
        return null;
    }

    public void doInit() throws Exception {
        super.doInit();
        this.forceLazyInitialization();
    }

    public String getComponentParameterJsonSchema(String componentName) throws IOException {
        Class<?> clazz;
        Object instance = this.getRegistry().lookupByNameAndType(componentName, Component.class);
        if (instance != null) {
            clazz = instance.getClass();
        } else {
            clazz = this.getFactoryFinder("META-INF/services/org/apache/camel/component/").findClass(componentName).orElse(null);
            if (clazz == null) {
                instance = this.hasComponent(componentName);
                if (instance != null) {
                    clazz = instance.getClass();
                } else {
                    return null;
                }
            }
        }
        if ("ActiveMQComponent".equals(clazz.getSimpleName())) {
            return this.getComponentParameterJsonSchema("jms");
        }
        return this.getJsonSchema(clazz.getPackage().getName(), componentName);
    }

    public String getDataFormatParameterJsonSchema(String dataFormatName) throws IOException {
        Class clazz;
        Object instance = this.getRegistry().lookupByNameAndType(dataFormatName, DataFormat.class);
        if (instance != null) {
            clazz = instance.getClass();
        } else {
            clazz = this.getFactoryFinder("META-INF/services/org/apache/camel/dataformat/").findClass(dataFormatName).orElse(null);
            if (clazz == null) {
                return null;
            }
        }
        return this.getJsonSchema(clazz.getPackage().getName(), dataFormatName);
    }

    public String getLanguageParameterJsonSchema(String languageName) throws IOException {
        Class clazz;
        Object instance = this.getRegistry().lookupByNameAndType(languageName, Language.class);
        if (instance != null) {
            clazz = instance.getClass();
        } else {
            clazz = this.getFactoryFinder("META-INF/services/org/apache/camel/language/").findClass(languageName).orElse(null);
            if (clazz == null) {
                return null;
            }
        }
        return this.getJsonSchema(clazz.getPackage().getName(), languageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJsonSchema(String packageName, String name) throws IOException {
        String path = packageName.replace('.', '/') + "/" + name + ".json";
        InputStream inputStream = this.getClassResolver().loadResourceAsStream(path);
        if (inputStream != null) {
            try {
                String string = IOHelper.loadText((InputStream)inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        return null;
    }

    public String getTestExcludeRoutes() {
        throw new UnsupportedOperationException();
    }
}

