/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.List;
import java.util.Optional;

@ConfigRoot(name="camel", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public class CamelConfig {
    @ConfigItem
    public BootstrapConfig bootstrap;
    @ConfigItem
    public ServiceConfig service;
    @ConfigItem
    public RuntimeCatalogConfig runtimeCatalog;
    @ConfigItem
    public RoutesDiscoveryConfig routesDiscovery;
    @ConfigItem(name="native")
    public NativeConfig native_;
    @Deprecated(forRemoval=true)
    @ConfigItem
    public CSimpleConfig csimple;
    @ConfigItem
    public ExpressionConfig expression;
    @ConfigItem
    public EventBridgeConfig eventBridge;
    @ConfigItem(defaultValue="false")
    public boolean sourceLocationEnabled;

    @ConfigGroup
    public static class EventBridgeConfig {
        @ConfigItem(defaultValue="true")
        public boolean enabled;
    }

    @ConfigGroup
    public static class ExpressionConfig {
        @ConfigItem(defaultValue="warn")
        public FailureRemedy onBuildTimeAnalysisFailure;
        @ConfigItem(defaultValue="true")
        public boolean extractionEnabled;
    }

    @Deprecated(forRemoval=true)
    @ConfigGroup
    public static class CSimpleConfig {
        @ConfigItem(defaultValue="warn")
        public FailureRemedy onBuildTimeAnalysisFailure;
    }

    @ConfigGroup
    public static class RuntimeCatalogConfig {
        @ConfigItem(defaultValue="true")
        public boolean components;
        @ConfigItem(defaultValue="true")
        public boolean languages;
        @ConfigItem(defaultValue="true")
        public boolean dataformats;
        @ConfigItem(defaultValue="true")
        public boolean models;
    }

    @ConfigGroup
    public static class ReflectionConfig {
        @ConfigItem
        public Optional<List<String>> excludePatterns;
        @ConfigItem
        public Optional<List<String>> includePatterns;
        @ConfigItem(defaultValue="false")
        public boolean serializationEnabled;
    }

    @ConfigGroup
    public static class NativeConfig {
        @ConfigItem
        public ReflectionConfig reflection;
    }

    @ConfigGroup
    public static class ServiceRegistryConfig {
        @ConfigItem
        public Optional<List<String>> excludePatterns;
        @ConfigItem
        public Optional<List<String>> includePatterns;
    }

    @ConfigGroup
    public static class ServiceDiscoveryConfig {
        @ConfigItem
        public Optional<List<String>> excludePatterns;
        @ConfigItem
        public Optional<List<String>> includePatterns;
    }

    @ConfigGroup
    public static class ServiceConfig {
        @ConfigItem
        public ServiceDiscoveryConfig discovery;
        @ConfigItem
        public ServiceRegistryConfig registry;
    }

    @ConfigGroup
    public static class RoutesDiscoveryConfig {
        @ConfigItem(defaultValue="true")
        public boolean enabled;
        @ConfigItem
        public Optional<List<String>> excludePatterns;
        @ConfigItem
        public Optional<List<String>> includePatterns;
    }

    @ConfigGroup
    public static class BootstrapConfig {
        @ConfigItem(defaultValue="true")
        public boolean enabled;
    }

    public static enum FailureRemedy {
        fail,
        warn,
        ignore;

    }
}

