/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import java.util.function.BooleanSupplier;
import org.eclipse.microprofile.config.ConfigProvider;

public final class CamelConfigFlags {
    private CamelConfigFlags() {
    }

    private static boolean asBoolean(String key, boolean defaultValue) {
        return ConfigProvider.getConfig().getOptionalValue(key, Boolean.class).orElse(defaultValue);
    }

    public static final class RuntimeCatalogEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return CamelConfigFlags.asBoolean("quarkus.camel.runtime-catalog.components", true) || CamelConfigFlags.asBoolean("quarkus.camel.runtime-catalog.languages", true) || CamelConfigFlags.asBoolean("quarkus.camel.runtime-catalog.dataformats", true) || CamelConfigFlags.asBoolean("quarkus.camel.runtime-catalog.models", true);
        }
    }

    public static final class RoutesDiscoveryEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return CamelConfigFlags.asBoolean("quarkus.camel.routes-discovery.enabled", true);
        }
    }
}

