/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.quarkus.core.events.ComponentAddEvent;
import org.apache.camel.quarkus.core.events.ComponentRemoveEvent;
import org.apache.camel.quarkus.core.events.EndpointAddEvent;
import org.apache.camel.quarkus.core.events.EndpointRemoveEvent;
import org.apache.camel.quarkus.core.events.ServiceAddEvent;
import org.apache.camel.quarkus.core.events.ServiceRemoveEvent;
import org.apache.camel.quarkus.core.events.ThreadPoolAddEvent;
import org.apache.camel.quarkus.core.events.ThreadPoolRemoveEvent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.util.function.Suppliers;

public class CamelLifecycleEventBridge
implements LifecycleStrategy {
    private final Supplier<BeanManager> beanManager = Suppliers.memorize(() -> ((ArcContainer)Arc.container()).beanManager());
    private final Set<String> observedLifecycleEvents;

    public CamelLifecycleEventBridge(Set<String> observedLifecycleEvents) {
        this.observedLifecycleEvents = observedLifecycleEvents;
    }

    private <T extends CamelEvent> void fireEvent(T event) {
        this.beanManager.get().getEvent().select(CamelEvent.class, new Annotation[0]).fire(event);
    }

    public void onComponentAdd(String name, Component component) {
        if (this.observedLifecycleEvents.contains(ComponentAddEvent.class.getName())) {
            this.fireEvent(new ComponentAddEvent(component));
        }
    }

    public void onComponentRemove(String name, Component component) {
        if (this.observedLifecycleEvents.contains(ComponentRemoveEvent.class.getName())) {
            this.fireEvent(new ComponentRemoveEvent(component));
        }
    }

    public void onEndpointAdd(Endpoint endpoint) {
        if (this.observedLifecycleEvents.contains(EndpointAddEvent.class.getName())) {
            this.fireEvent(new EndpointAddEvent(endpoint));
        }
    }

    public void onEndpointRemove(Endpoint endpoint) {
        if (this.observedLifecycleEvents.contains(EndpointRemoveEvent.class.getName())) {
            this.fireEvent(new EndpointRemoveEvent(endpoint));
        }
    }

    public void onThreadPoolAdd(CamelContext camelContext, ThreadPoolExecutor threadPool, String id, String sourceId, String routeId, String threadPoolProfileId) {
        if (this.observedLifecycleEvents.contains(ThreadPoolAddEvent.class.getName())) {
            this.fireEvent(new ThreadPoolAddEvent(camelContext, threadPool, id, sourceId, routeId, threadPoolProfileId));
        }
    }

    public void onThreadPoolRemove(CamelContext camelContext, ThreadPoolExecutor threadPool) {
        if (this.observedLifecycleEvents.contains(ThreadPoolRemoveEvent.class.getName())) {
            this.fireEvent(new ThreadPoolRemoveEvent(camelContext, threadPool));
        }
    }

    public void onServiceAdd(CamelContext context, Service service, Route route) {
        if (this.observedLifecycleEvents.contains(ServiceAddEvent.class.getName())) {
            this.fireEvent(new ServiceAddEvent(context, service, route));
        }
    }

    public void onServiceRemove(CamelContext context, Service service, Route route) {
        if (this.observedLifecycleEvents.contains(ServiceAddEvent.class.getName())) {
            this.fireEvent(new ServiceRemoveEvent(context, service, route));
        }
    }

    public void onRoutesAdd(Collection<Route> routes) {
    }

    public void onRoutesRemove(Collection<Route> routes) {
    }

    public void onRouteContextCreate(Route route) {
    }

    public void onContextInitialized(CamelContext context) throws VetoCamelContextStartException {
    }
}

