/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Singleton;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.core.CamelRuntime;
import org.apache.camel.spi.Registry;

@Singleton
public class CamelProducers {
    private volatile CamelContext context;
    private volatile CamelRuntime runtime;

    public void setContext(CamelContext context) {
        this.context = context;
    }

    public void setRuntime(CamelRuntime runtime) {
        this.runtime = runtime;
    }

    @Singleton
    @Produces
    CamelContext camelContext() {
        return this.context;
    }

    @Singleton
    @Produces
    Registry camelRegistry() {
        return this.context.getRegistry();
    }

    @Singleton
    @Produces
    CamelRuntime camelRuntime() {
        return this.runtime;
    }

    @Produces
    ProducerTemplate camelProducerTemplate(InjectionPoint injectionPoint) {
        return this.context.createProducerTemplate();
    }

    @Produces
    FluentProducerTemplate camelFluentProducerTemplate(InjectionPoint injectionPoint) {
        return this.context.createFluentProducerTemplate();
    }

    @Produces
    ConsumerTemplate camelConsumerTemplate() {
        return this.context.createConsumerTemplate();
    }
}

