/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;

public class CamelQuarkusClassResolver
implements ClassResolver {
    private Set<ClassLoader> classLoaders;
    private final ClassLoader applicationContextClassLoader;

    public CamelQuarkusClassResolver(ClassLoader applicationContextClassLoader) {
        this.applicationContextClassLoader = applicationContextClassLoader;
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (this.classLoaders == null) {
            this.classLoaders = new LinkedHashSet<ClassLoader>();
        }
        this.classLoaders.add(classLoader);
    }

    public Set<ClassLoader> getClassLoaders() {
        if (this.classLoaders == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.classLoaders);
    }

    public ClassLoader getClassLoader(String name) {
        if (this.classLoaders != null) {
            for (ClassLoader cl : this.classLoaders) {
                if (!name.equals(cl.getName())) continue;
                return cl;
            }
        }
        return null;
    }

    public Class<?> resolveClass(String name) {
        Class<?> result = this.loadClass(name, this.applicationContextClassLoader);
        if (result != null) {
            return result;
        }
        if (ObjectHelper.isNotEmpty(this.classLoaders)) {
            for (ClassLoader loader : this.classLoaders) {
                result = this.loadClass(name, loader);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public <T> Class<T> resolveClass(String name, Class<T> type) {
        return CastUtils.cast(this.loadClass(name, this.applicationContextClassLoader));
    }

    public Class<?> resolveClass(String name, ClassLoader loader) {
        return this.loadClass(name, loader);
    }

    public <T> Class<T> resolveClass(String name, Class<T> type, ClassLoader loader) {
        return CastUtils.cast(this.loadClass(name, loader));
    }

    public Class<?> resolveMandatoryClass(String name) throws ClassNotFoundException {
        Class<?> answer = this.resolveClass(name);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    public <T> Class<T> resolveMandatoryClass(String name, Class<T> type) throws ClassNotFoundException {
        Class<T> answer = this.resolveClass(name, type);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    public Class<?> resolveMandatoryClass(String name, ClassLoader loader) throws ClassNotFoundException {
        Class<?> answer = this.resolveClass(name, loader);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    public <T> Class<T> resolveMandatoryClass(String name, Class<T> type, ClassLoader loader) throws ClassNotFoundException {
        Class<T> answer = this.resolveClass(name, type, loader);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    public InputStream loadResourceAsStream(String uri) {
        return ObjectHelper.loadResourceAsStream((String)uri, (ClassLoader)this.applicationContextClassLoader);
    }

    public URL loadResourceAsURL(String uri) {
        return ObjectHelper.loadResourceAsURL((String)uri, (ClassLoader)this.applicationContextClassLoader);
    }

    public Enumeration<URL> loadResourcesAsURL(String uri) {
        return this.loadAllResourcesAsURL(uri);
    }

    public Enumeration<URL> loadAllResourcesAsURL(String uri) {
        return ObjectHelper.loadResourcesAsURL((String)uri);
    }

    protected Class<?> loadClass(String name, ClassLoader loader) {
        return ObjectHelper.loadClass((String)name, (ClassLoader)loader);
    }
}

