/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import io.quarkus.runtime.Quarkus;
import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.quarkus.core.CamelRuntime;
import org.apache.camel.quarkus.main.CamelMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelMainRuntime
implements CamelRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelMainRuntime.class);
    private final CamelMain main;
    private final long shutdownTimeoutMs;
    private volatile Thread mainThread;

    public CamelMainRuntime(CamelMain main, long shutdownTimeoutMs) {
        this.main = main;
        this.shutdownTimeoutMs = shutdownTimeoutMs;
    }

    @Override
    public void start(String[] args) {
        if (args.length > 0) {
            LOGGER.info("Starting camel-quarkus with args: {}", (Object)Arrays.toString(args));
        }
        try {
            Thread worker;
            this.main.parseArguments(args);
            this.main.startEngine();
            this.mainThread = worker = new Thread(() -> {
                try {
                    this.main.runEngine();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to start application", (Throwable)e);
                    this.stop();
                    throw new RuntimeException(e);
                }
            }, "camel-main");
            worker.start();
        }
        catch (Exception e) {
            LOGGER.error("Failed to start application", (Throwable)e);
            this.stop();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        this.main.stop();
        Thread worker = this.mainThread;
        if (worker != null) {
            try {
                worker.join(this.shutdownTimeoutMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public int waitForExit() {
        Quarkus.waitForExit();
        return this.main.getExitCode();
    }

    public CamelContext getCamelContext() {
        return this.main.getCamelContext();
    }
}

