/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.endpoint.EndpointRouteBuilder;
import org.apache.camel.builder.endpoint.LambdaEndpointRouteBuilder;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.impl.engine.DefaultVariableRepositoryFactory;
import org.apache.camel.quarkus.core.CamelConfig;
import org.apache.camel.quarkus.core.CamelContextRuntime;
import org.apache.camel.quarkus.core.CamelLifecycleEventBridge;
import org.apache.camel.quarkus.core.CamelManagementEventBridge;
import org.apache.camel.quarkus.core.CamelProducers;
import org.apache.camel.quarkus.core.CamelRuntime;
import org.apache.camel.quarkus.core.CamelRuntimeCatalog;
import org.apache.camel.quarkus.core.FastCamelContext;
import org.apache.camel.quarkus.core.FastTypeConverterInjector;
import org.apache.camel.quarkus.core.NoShutdownStrategy;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.ComponentNameResolver;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.ModelToYAMLDumper;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.VariableRepositoryFactory;

@Recorder
public class CamelContextRecorder {
    public RuntimeValue<CamelContext> createContext(RuntimeValue<Registry> registry, RuntimeValue<TypeConverterRegistry> typeConverterRegistry, RuntimeValue<ModelJAXBContextFactory> contextFactory, RuntimeValue<ModelToXMLDumper> xmlModelDumper, RuntimeValue<ModelToYAMLDumper> yamlModelDumper, RuntimeValue<FactoryFinderResolver> factoryFinderResolver, RuntimeValue<ComponentNameResolver> componentNameResolver, RuntimeValue<PackageScanClassResolver> packageScanClassResolver, RuntimeValue<ModelReifierFactory> modelReifierFactory, BeanContainer beanContainer, String version, CamelConfig config) {
        FastCamelContext context = new FastCamelContext(version, (ModelToXMLDumper)xmlModelDumper.getValue(), (ModelToYAMLDumper)yamlModelDumper.getValue());
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        ExtendedCamelContext extendedCamelContext = context.getCamelContextExtension();
        context.setApplicationContextClassLoader(tccl);
        extendedCamelContext.addContextPlugin(FactoryFinderResolver.class, (Object)((FactoryFinderResolver)factoryFinderResolver.getValue()));
        extendedCamelContext.addContextPlugin(RuntimeCamelCatalog.class, (Object)new CamelRuntimeCatalog(config.runtimeCatalog));
        extendedCamelContext.addContextPlugin(VariableRepositoryFactory.class, (Object)new DefaultVariableRepositoryFactory((CamelContext)context));
        extendedCamelContext.setRegistry((Registry)registry.getValue());
        context.setModelReifierFactory((ModelReifierFactory)modelReifierFactory.getValue());
        TypeConverterRegistry typeConverterRegistryValue = (TypeConverterRegistry)typeConverterRegistry.getValue();
        typeConverterRegistryValue.setInjector((Injector)new FastTypeConverterInjector((CamelContext)context));
        context.setTypeConverterRegistry(typeConverterRegistryValue);
        if (typeConverterRegistryValue instanceof TypeConverter) {
            context.setTypeConverter((TypeConverter)typeConverterRegistryValue);
        }
        context.setLoadTypeConverters(false);
        extendedCamelContext.addContextPlugin(ModelJAXBContextFactory.class, (Object)((ModelJAXBContextFactory)contextFactory.getValue()));
        extendedCamelContext.addContextPlugin(PackageScanClassResolver.class, (Object)((PackageScanClassResolver)packageScanClassResolver.getValue()));
        context.build();
        extendedCamelContext.addContextPlugin(ComponentNameResolver.class, (Object)((ComponentNameResolver)componentNameResolver.getValue()));
        ((CamelProducers)beanContainer.beanInstance(CamelProducers.class, new Annotation[0])).setContext((CamelContext)context);
        return new RuntimeValue((Object)context);
    }

    public void customize(RuntimeValue<CamelContext> context, RuntimeValue<CamelContextCustomizer> contextCustomizer) {
        ((CamelContextCustomizer)contextCustomizer.getValue()).configure((CamelContext)context.getValue());
    }

    public RuntimeValue<CamelRuntime> createRuntime(BeanContainer beanContainer, RuntimeValue<CamelContext> context) {
        CamelContextRuntime runtime = new CamelContextRuntime((CamelContext)context.getValue());
        ((CamelProducers)beanContainer.beanInstance(CamelProducers.class, new Annotation[0])).setRuntime(runtime);
        return new RuntimeValue((Object)runtime);
    }

    public RuntimeValue<CamelContextCustomizer> createNoShutdownStrategyCustomizer() {
        return new RuntimeValue(context -> context.setShutdownStrategy((ShutdownStrategy)new NoShutdownStrategy()));
    }

    public RuntimeValue<CamelContextCustomizer> createSourceLocationEnabledCustomizer() {
        return new RuntimeValue(context -> context.setSourceLocationEnabled(Boolean.valueOf(true)));
    }

    public void addRoutes(RuntimeValue<CamelContext> context, List<String> nonCdiRoutesBuilderClassNames) {
        ArrayList<Object> allRoutesBuilders = new ArrayList<Object>();
        try {
            for (String string : nonCdiRoutesBuilderClassNames) {
                Class nonCdiRoutesBuilderClass = ((CamelContext)context.getValue()).getClassResolver().resolveClass(string, RoutesBuilder.class);
                allRoutesBuilders.add((RoutesBuilder)((CamelContext)context.getValue()).getInjector().newInstance(nonCdiRoutesBuilderClass));
            }
            for (final LambdaRouteBuilder lambdaRouteBuilder : ((CamelContext)context.getValue()).getRegistry().findByType(LambdaRouteBuilder.class)) {
                allRoutesBuilders.add(new RouteBuilder(){

                    public void configure() throws Exception {
                        lambdaRouteBuilder.accept((Object)this);
                    }
                });
            }
            for (final LambdaEndpointRouteBuilder lambdaEndpointRouteBuilder : ((CamelContext)context.getValue()).getRegistry().findByType(LambdaEndpointRouteBuilder.class)) {
                allRoutesBuilders.add(new EndpointRouteBuilder(){

                    public void configure() throws Exception {
                        lambdaEndpointRouteBuilder.accept((Object)this);
                    }
                });
            }
            allRoutesBuilders.addAll(((CamelContext)context.getValue()).getRegistry().findByType(RoutesBuilder.class));
            for (RoutesBuilder routesBuilder : allRoutesBuilders) {
                if (!(routesBuilder instanceof RouteConfigurationsBuilder)) continue;
                ((CamelContext)context.getValue()).addRoutesConfigurations((RouteConfigurationsBuilder)routesBuilder);
            }
            for (RoutesBuilder routesBuilder : allRoutesBuilders) {
                if (routesBuilder instanceof RouteConfigurationsBuilder) continue;
                ((CamelContext)context.getValue()).addRoutes(routesBuilder);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerLifecycleEventBridge(RuntimeValue<CamelContext> context, Set<String> observedLifecycleEvents) {
        ((CamelContext)context.getValue()).addLifecycleStrategy((LifecycleStrategy)new CamelLifecycleEventBridge(observedLifecycleEvents));
    }

    public void registerManagementEventBridge(RuntimeValue<CamelContext> camelContext, Set<String> observedManagementEvents) {
        ((CamelContext)camelContext.getValue()).getManagementStrategy().addEventNotifier((EventNotifier)new CamelManagementEventBridge(observedManagementEvents));
    }
}

