/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.CamelContext;
import org.apache.camel.quarkus.core.CamelRuntime;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelContextRuntime
implements CamelRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelContextRuntime.class);
    private final CamelContext camelContext;
    private final CountDownLatch latch;

    public CamelContextRuntime(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.latch = new CountDownLatch(1);
    }

    @Override
    public void start(String[] args) {
        if (args.length > 0) {
            LOGGER.info("Ignoring args: {}", (Object)Arrays.toString(args));
        }
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) throws Exception {
                CamelContextRuntime.this.latch.countDown();
            }

            public boolean isEnabled(CamelEvent event) {
                return event instanceof CamelEvent.CamelContextStoppedEvent;
            }
        });
        this.camelContext.start();
    }

    @Override
    public void stop() {
        this.camelContext.stop();
    }

    @Override
    public int waitForExit() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            LOGGER.warn("", (Throwable)e);
        }
        return 0;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

