/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.quarkus.core.CamelBeanQualifierResolver;
import org.apache.camel.spi.BeanRepository;

public final class RuntimeBeanRepository
implements BeanRepository {
    private final Map<String, CamelBeanQualifierResolver> beanQualifierResolvers;

    public RuntimeBeanRepository(Map<String, CamelBeanQualifierResolver> beanQualifierResolvers) {
        this.beanQualifierResolvers = beanQualifierResolvers;
    }

    private static <T> Set<Bean<? extends T>> resolveAmbiguity(BeanManager manager, Set<Bean<? extends T>> beans) {
        if (beans.size() > 1) {
            try {
                return Collections.singleton(manager.resolve(beans));
            }
            catch (AmbiguousResolutionException ambiguousResolutionException) {
                // empty catch block
            }
        }
        return beans;
    }

    private static <T> Map<String, T> getReferencesByTypeWithName(Class<T> type, Annotation ... qualifiers) {
        return RuntimeBeanRepository.getBeanManager().map(manager -> RuntimeBeanRepository.getReferencesByTypeWithName(manager, type, qualifiers)).orElseGet(Collections::emptyMap);
    }

    private static <T> Set<T> getReferencesByType(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        HashSet<T> answer = new HashSet<T>();
        for (Bean<T> bean : RuntimeBeanRepository.resolveAmbiguity(manager, manager.getBeans(type, qualifiers))) {
            T ref = RuntimeBeanRepository.getReference(manager, type, bean);
            if (ref == null) continue;
            answer.add(ref);
        }
        return answer;
    }

    private static <T> Optional<T> getReferenceByName(BeanManager manager, String name, Class<T> type) {
        Set beans = manager.getBeans(name);
        if (beans.isEmpty()) {
            beans = manager.getBeans(type, new Annotation[]{NamedLiteral.of((String)name)});
        }
        if (beans.isEmpty()) {
            beans = manager.getBeans(type, new Annotation[]{Identifier.Literal.of((String)name)});
        }
        return Optional.ofNullable(manager.resolve(beans)).map(bean -> RuntimeBeanRepository.getReference(manager, type, bean));
    }

    private static <T> T getReference(BeanManager manager, Class<T> type, Bean<?> bean) {
        return type.cast(manager.getReference(bean, Object.class, manager.createCreationalContext(bean)));
    }

    private static <T> Map<String, T> getReferencesByTypeWithName(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        HashMap<String, T> answer = new HashMap<String, T>();
        for (Bean bean : manager.getBeans(type, qualifiers)) {
            T ref = RuntimeBeanRepository.getReference(manager, type, bean);
            if (ref == null) continue;
            answer.put(bean.getName(), ref);
        }
        return answer;
    }

    private static Optional<BeanManager> getBeanManager() {
        ArcContainer container = Arc.container();
        if (container == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(container.beanManager());
    }

    public Object lookupByName(String name) {
        return this.lookupByNameAndType(name, Object.class);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        return RuntimeBeanRepository.getBeanManager().flatMap(manager -> RuntimeBeanRepository.getReferenceByName(manager, name, type)).orElse(null);
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        Optional<Annotation[]> qualifiers = this.resolveQualifiersForType(type);
        if (qualifiers.isPresent()) {
            return RuntimeBeanRepository.getReferencesByTypeWithName(type, qualifiers.get());
        }
        return RuntimeBeanRepository.getReferencesByTypeWithName(type, new Annotation[0]);
    }

    public <T> Set<T> findByType(Class<T> type) {
        Optional<Annotation[]> qualifiers = this.resolveQualifiersForType(type);
        if (qualifiers.isPresent()) {
            return RuntimeBeanRepository.getBeanManager().map(manager -> RuntimeBeanRepository.getReferencesByType(manager, type, (Annotation[])qualifiers.get())).orElseGet(Collections::emptySet);
        }
        return RuntimeBeanRepository.getBeanManager().map(manager -> RuntimeBeanRepository.getReferencesByType(manager, type, new Annotation[0])).orElseGet(Collections::emptySet);
    }

    public <T> T findSingleByType(Class<T> type) {
        List handles;
        ArcContainer container = Arc.container();
        Optional<Annotation[]> qualifiers = this.resolveQualifiersForType(type);
        if (container != null && (handles = qualifiers.isPresent() ? container.listAll(type, qualifiers.get()) : container.listAll(type, new Annotation[0])).size() > 0) {
            return (T)((InstanceHandle)handles.get(0)).get();
        }
        return null;
    }

    private Optional<Annotation[]> resolveQualifiersForType(Class<?> type) {
        CamelBeanQualifierResolver resolver = this.beanQualifierResolvers.get(type.getName());
        if (resolver != null) {
            return Optional.ofNullable(resolver.resolveQualifiers());
        }
        return Optional.empty();
    }
}

