/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fop.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.fop.FopComponent;
import org.apache.camel.component.fop.springboot.FopComponentConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, FopComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.fop"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class FopComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private FopComponentConfiguration configuration;

    public FopComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureFopComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)FopComponentAutoConfiguration.this.camelContext, (Object)((Object)FopComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)FopComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.fop.customizer"}) && target instanceof FopComponent;
            }
        };
    }
}

