/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.k;

import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.impl.DefaultModelReifierFactory;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spring.boot.k.ApplicationConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationRoutesCustomizer
implements CamelContextCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRoutesCustomizer.class);
    private final ApplicationConfiguration config;

    public ApplicationRoutesCustomizer(ApplicationConfiguration config) {
        this.config = config;
    }

    public void configure(CamelContext camelContext) {
        ((Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class)).setModelReifierFactory((ModelReifierFactory)new ApplicationModelReifierFactory(this.config));
    }

    public static class ApplicationModelReifierFactory
    extends DefaultModelReifierFactory {
        private final ApplicationConfiguration config;

        public ApplicationModelReifierFactory(ApplicationConfiguration config) {
            this.config = config;
        }

        public Route createRoute(CamelContext camelContext, Object routeDefinition) {
            if (routeDefinition instanceof RouteDefinition) {
                this.override((RouteDefinition)routeDefinition);
            }
            return super.createRoute(camelContext, routeDefinition);
        }

        public void override(RouteDefinition definition) {
            if (this.config.getRoutes().getOverrides().isEmpty()) {
                return;
            }
            String id = definition.getRouteId();
            FromDefinition from = definition.getInput();
            for (ApplicationConfiguration.RouteOverride override : this.config.getRoutes().getOverrides()) {
                String overrideRouteId = override.getId();
                String overrideRouteFrom = override.getInput().getFrom();
                if (ObjectHelper.isEmpty((String)overrideRouteId) && ObjectHelper.isEmpty((String)overrideRouteFrom) || ObjectHelper.isNotEmpty((String)overrideRouteId) && !Objects.equals(overrideRouteId, id) || ObjectHelper.isNotEmpty((String)overrideRouteFrom) && !Objects.equals(from.getEndpointUri(), overrideRouteFrom)) continue;
                LOGGER.debug("Replace '{}' --> '{}' for route {}", new Object[]{from.getEndpointUri(), override.getInput().getWith(), definition.getRouteId()});
                from.setUri(override.getInput().getWith());
                break;
            }
        }
    }
}

