/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.k;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spring.boot.k.ApplicationConfiguration;
import org.apache.camel.support.EventNotifierSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;

public class ApplicationShutdownCustomizer
implements CamelContextCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationShutdownCustomizer.class);
    private final ApplicationContext applicationContext;
    private final ApplicationConfiguration config;

    public ApplicationShutdownCustomizer(ApplicationContext applicationContext, ApplicationConfiguration config) {
        this.applicationContext = applicationContext;
        this.config = config;
    }

    public void configure(CamelContext camelContext) {
        if (this.config.getShutdown().getMaxMessages() > 0) {
            LOGGER.info("Configure the JVM to terminate after {} messages and none inflight (strategy: {})", (Object)this.config.getShutdown().getMaxMessages(), (Object)this.config.getShutdown().getStrategy());
            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new ShutdownEventHandler(this.applicationContext, camelContext, this.config));
        }
    }

    private static final class ShutdownEventHandler
    extends EventNotifierSupport {
        private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownEventHandler.class);
        private final ApplicationContext applicationContext;
        private final CamelContext camelContext;
        private final ApplicationConfiguration config;
        private final AtomicInteger counter;
        private final AtomicBoolean shutdownStarted;

        ShutdownEventHandler(ApplicationContext applicationContext, CamelContext camelContext, ApplicationConfiguration config) {
            this.applicationContext = applicationContext;
            this.camelContext = camelContext;
            this.config = config;
            this.counter = new AtomicInteger();
            this.shutdownStarted = new AtomicBoolean();
        }

        public void notify(CamelEvent event) throws Exception {
            int currentCounter = this.counter.incrementAndGet();
            int currentInflight = this.camelContext.getInflightRepository().size();
            LOGGER.debug("CamelEvent received (max: {}, handled: {}, inflight: {})", new Object[]{this.config.getShutdown().getMaxMessages(), currentCounter, currentInflight});
            if (currentCounter < this.config.getShutdown().getMaxMessages() || currentInflight != 0) {
                return;
            }
            if (!this.shutdownStarted.compareAndExchange(false, true)) {
                this.camelContext.getExecutorServiceManager().newThread("ShutdownStrategy", () -> {
                    try {
                        LOGGER.info("Initiate runtime shutdown (max: {}, handled: {})", (Object)this.config.getShutdown().getMaxMessages(), (Object)currentCounter);
                        if (this.config.getShutdown().getStrategy() == ApplicationConfiguration.ShutdownStrategy.APPLICATION) {
                            SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
                        } else {
                            this.camelContext.shutdown();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error while shutting down the runtime", (Throwable)e);
                    }
                }).start();
            }
        }

        public boolean isEnabled(CamelEvent event) {
            return event instanceof CamelEvent.ExchangeCompletedEvent || event instanceof CamelEvent.ExchangeFailedEvent;
        }
    }
}

