/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.k;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class ApplicationEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.configurePropertySources(environment, application);
    }

    private void configurePropertySources(ConfigurableEnvironment environment, SpringApplication application) {
        Properties sysProperties = new Properties();
        sysProperties.put("camel.kubernetes-config.client-enabled", "false");
        environment.getPropertySources().addLast((PropertySource)new PropertiesPropertySource("camel-k-sys", sysProperties));
        environment.getPropertySources().addLast((PropertySource)new PropertiesPropertySource("camel-k-app", ApplicationEnvironmentPostProcessor.loadApplicationProperties()));
        environment.getPropertySources().addLast((PropertySource)new PropertiesPropertySource("camel-k-usr-configmap", ApplicationEnvironmentPostProcessor.loadConfigMapUserProperties()));
        environment.getPropertySources().addLast((PropertySource)new PropertiesPropertySource("camel-k-usr-secrets", ApplicationEnvironmentPostProcessor.loadSecretsProperties()));
        environment.getPropertySources().addLast((PropertySource)new PropertiesPropertySource("camel-k-servicebindings", ApplicationEnvironmentPostProcessor.loadServiceBindingsProperties()));
    }

    private static Properties loadApplicationProperties() {
        Properties properties;
        block9: {
            String conf = System.getProperty("camel.k.conf", System.getenv("CAMEL_K_CONF"));
            properties = new Properties();
            if (ObjectHelper.isEmpty((String)conf)) {
                return properties;
            }
            try {
                Path confPath = Paths.get(conf, new String[0]);
                if (!Files.exists(confPath, new LinkOption[0]) || Files.isDirectory(confPath, new LinkOption[0])) break block9;
                try (BufferedReader reader = Files.newBufferedReader(confPath);){
                    properties.load(reader);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    private static Properties loadConfigMapUserProperties() {
        return ApplicationEnvironmentPostProcessor.loadUserProperties("camel.k.mount-path.configmaps", "CAMEL_K_MOUNT_PATH_CONFIGMAPS", "_configmaps");
    }

    private static Properties loadSecretsProperties() {
        return ApplicationEnvironmentPostProcessor.loadUserProperties("camel.k.mount-path.secrets", "CAMEL_K_MOUNT_PATH_SECRETS", "_secrets");
    }

    private static Properties loadServiceBindingsProperties() {
        return ApplicationEnvironmentPostProcessor.loadUserProperties("camel.k.mount-path.servicebindings", "CAMEL_K_MOUNT_PATH_SERVICEBINDINGS", "_servicebindings");
    }

    private static Properties loadUserProperties(String property, String env, String subpath) {
        Object conf;
        Object path = System.getProperty(property, System.getenv(env));
        if (path == null && (conf = System.getProperty("camel.k.conf.d", System.getenv("CAMEL_K_CONF_D"))) != null) {
            if (!((String)conf).endsWith("/")) {
                conf = (String)conf + "/";
            }
            path = (String)conf + subpath;
        }
        Properties properties = new Properties();
        if (ObjectHelper.isEmpty((String)path)) {
            return properties;
        }
        Path root = Paths.get((String)path, new String[0]);
        if (Files.exists(root, new LinkOption[0])) {
            FileVisitor<Path> visitor = ApplicationEnvironmentPostProcessor.propertiesCollector(properties);
            try {
                Files.walkFileTree(root, visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    private static FileVisitor<Path> propertiesCollector(final Properties properties) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Objects.requireNonNull(file);
                Objects.requireNonNull(attrs);
                if (Files.isDirectory(file, new LinkOption[0]) || Files.isSymbolicLink(file)) {
                    return FileVisitResult.CONTINUE;
                }
                if (file.toFile().getAbsolutePath().endsWith(".properties")) {
                    try (BufferedReader reader = Files.newBufferedReader(file);){
                        Properties p = new Properties();
                        p.load(reader);
                        p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> properties.put(String.valueOf(key), String.valueOf(value))));
                    }
                }
                try {
                    properties.put(file.getFileName().toString(), Files.readString(file, StandardCharsets.UTF_8));
                }
                catch (MalformedInputException mie) {
                    LOGGER.info("Cannot transform {} into UTF-8 text, skipping.", (Object)file);
                }
                return FileVisitResult.CONTINUE;
            }
        };
    }
}

