/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.k;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="camel.k")
public class ApplicationConfiguration {
    private boolean enabled;
    @NestedConfigurationProperty
    private final ShutdownProperties shutdown = new ShutdownProperties();
    @NestedConfigurationProperty
    private final RoutesProperties routes = new RoutesProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ShutdownProperties getShutdown() {
        return this.shutdown;
    }

    public RoutesProperties getRoutes() {
        return this.routes;
    }

    public static class ShutdownProperties {
        private int maxMessages = 0;
        private ShutdownStrategy strategy = ShutdownStrategy.APPLICATION;

        public int getMaxMessages() {
            return this.maxMessages;
        }

        public void setMaxMessages(int maxMessages) {
            this.maxMessages = maxMessages;
        }

        public ShutdownStrategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(ShutdownStrategy strategy) {
            this.strategy = strategy;
        }
    }

    public static class RoutesProperties {
        @NestedConfigurationProperty
        private final List<RouteOverride> overrides = new ArrayList<RouteOverride>();

        public List<RouteOverride> getOverrides() {
            return this.overrides;
        }
    }

    public static class RouteInputOverride {
        private String from;
        private String with;

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getWith() {
            return this.with;
        }

        public void setWith(String with) {
            this.with = with;
        }
    }

    public static class RouteOverride {
        private String id;
        private RouteInputOverride input;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public RouteInputOverride getInput() {
            return this.input;
        }

        public void setInput(RouteInputOverride input) {
            this.input = input;
        }
    }

    public static enum ShutdownStrategy {
        APPLICATION,
        CAMEL;

    }
}

