/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.async;

import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.async.TAsyncMethodCall;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TNonblockingTransport;

public abstract class TAsyncClient {
    protected final TProtocolFactory protocolFactory;
    protected final TNonblockingTransport transport;
    protected final TAsyncClientManager manager;
    private TAsyncMethodCall currentMethod;
    private Throwable error;
    private long timeout;

    public TAsyncClient(TProtocolFactory protocolFactory, TAsyncClientManager manager, TNonblockingTransport transport) {
        this(protocolFactory, manager, transport, 0L);
    }

    public TAsyncClient(TProtocolFactory protocolFactory, TAsyncClientManager manager, TNonblockingTransport transport, long timeout) {
        this.protocolFactory = protocolFactory;
        this.manager = manager;
        this.transport = transport;
        this.timeout = timeout;
    }

    public TProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean hasTimeout() {
        return this.timeout > 0L;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Throwable getError() {
        return this.error;
    }

    protected void checkReady() {
        if (this.currentMethod != null) {
            throw new IllegalStateException("Client is currently executing another method: " + this.currentMethod.getClass().getName());
        }
        if (this.error != null) {
            throw new IllegalStateException("Client has an error!", this.error);
        }
    }

    protected void onComplete() {
        this.currentMethod = null;
    }

    protected void onError(Throwable throwable) {
        this.transport.close();
        this.currentMethod = null;
        this.error = throwable;
    }
}

