/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.maven.deployer.WebApplicationRewriter;
import org.apache.cocoon.maven.deployer.monolithic.DeploymentException;
import org.apache.cocoon.maven.deployer.monolithic.RuleBasedZipExtractor;
import org.apache.cocoon.maven.deployer.monolithic.XPatchDeployer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.war.AbstractWarMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.MavenMetadataSource;

public abstract class AbstractDeployMojo
extends AbstractWarMojo {
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private MavenMetadataSource metadataSource;
    private ArtifactRepository localRepository;
    private List remoteArtifactRepositories;
    private MavenProject project;
    private File classesDirectory;
    private File webappDirectory;
    private File warSourceDirectory;
    private String webXml;
    private boolean useShieldingClassLoader = false;
    private boolean useShieldingRepository = false;

    protected void deployWebapp() throws MojoExecutionException, MojoFailureException {
        this.buildExplodedWebapp(this.getWebappDirectory());
        try {
            super.copyResources(this.getWarSourceDirectory(), this.getWebappDirectory());
        }
        catch (IOException e) {
            throw new MojoExecutionException("A problem occurred while copying webapp resources.", (Exception)e);
        }
        AbstractDeployMojo.xpatch(AbstractDeployMojo.getBlockArtifactsAsMap(this.getProject(), this.getLog()), new File[0], this.getWebappDirectory(), this.getLog());
        if (this.useShieldingClassLoader) {
            WebApplicationRewriter.shieldWebapp(new File(this.getWebappDirectory(), "WEB-INF"), this.getLog(), this.useShieldingRepository);
        }
    }

    public static void xpatch(Map libraries, File[] xpatchFiles, File basedir, Log log) throws DeploymentException {
        XPatchDeployer xwebPatcher = new XPatchDeployer("WEB-INF");
        xwebPatcher.setBasedir(basedir);
        xwebPatcher.setLogger(log);
        Iterator it = libraries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object id = entry.getKey();
            File lib = (File)entry.getValue();
            try {
                log.debug((CharSequence)("Scanning " + id));
                RuleBasedZipExtractor zipExtractor = new RuleBasedZipExtractor(basedir, log);
                zipExtractor.addRule("META-INF/cocoon/xpatch/*.xweb", xwebPatcher);
                zipExtractor.extract(lib);
            }
            catch (IOException e) {
                throw new DeploymentException("Can't deploy '" + lib.getAbsolutePath() + "'.", e);
            }
        }
        for (int i = 0; i < xpatchFiles.length; ++i) {
            File patch = xpatchFiles[i];
            try {
                xwebPatcher.addPatch(patch);
                log.info((CharSequence)("Adding xpatch: " + patch));
                continue;
            }
            catch (IOException e) {
                throw new DeploymentException("Can't use patches '" + patch + "'.", e);
            }
        }
        FileInputStream sourceWebXmlFile = null;
        File webXml = new File(basedir, "WEB-INF/web.xml");
        try {
            sourceWebXmlFile = new FileInputStream(webXml);
            xwebPatcher.applyPatches(sourceWebXmlFile, "WEB-INF/web.xml");
        }
        catch (FileNotFoundException e) {
            try {
                throw new DeploymentException("Can't apply patches on " + webXml + ".", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(sourceWebXmlFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)sourceWebXmlFile);
    }

    public static Map getBlockArtifactsAsMap(MavenProject project, Log log) throws MojoExecutionException {
        HashMap<String, File> files = new HashMap<String, File>();
        Iterator it = project.getArtifacts().iterator();
        while (it.hasNext()) {
            StringBuffer msg;
            Artifact artifact = (Artifact)it.next();
            String id = artifact.getArtifactId();
            if (files.containsKey(id)) {
                msg = new StringBuffer("There are at least two artifacts with the ID '");
                msg.append(id);
                msg.append("':");
                msg.append(SystemUtils.LINE_SEPARATOR);
                Iterator ai = project.getArtifacts().iterator();
                while (ai.hasNext()) {
                    Artifact current = (Artifact)ai.next();
                    if (!current.getArtifactId().equals(id)) continue;
                    msg.append(artifact);
                    msg.append(SystemUtils.LINE_SEPARATOR);
                    List l = current.getDependencyTrail();
                    Iterator i = l.iterator();
                    while (i.hasNext()) {
                        msg.append("    ");
                        msg.append(i.next().toString());
                        msg.append(SystemUtils.LINE_SEPARATOR);
                    }
                }
                throw new MojoExecutionException(msg.toString());
            }
            files.put(id, artifact.getFile());
            if (!log.isDebugEnabled()) continue;
            msg = new StringBuffer("Deploying " + artifact);
            List l = artifact.getDependencyTrail();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                msg.append("    ");
                msg.append(i.next().toString());
                msg.append(SystemUtils.LINE_SEPARATOR);
            }
            log.debug((CharSequence)msg.toString());
        }
        return files;
    }
}

