/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.cocoon.maven.deployer.WebXmlRewriter;
import org.apache.cocoon.maven.deployer.servlet.ShieldedClassLoaderManager;
import org.apache.cocoon.maven.deployer.servlet.ShieldingListener;
import org.apache.cocoon.maven.deployer.servlet.ShieldingServlet;
import org.apache.cocoon.maven.deployer.servlet.ShieldingServletFilter;
import org.apache.cocoon.maven.deployer.utils.XMLUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.w3c.dom.Document;

public class WebApplicationRewriter {
    protected static final String CLASSLOADER_JAR = "cocoon-deployer-plugin-classloading.jar";
    protected static final String JAR_ENTRY_PREFIX = ShieldedClassLoaderManager.class.getPackage().getName().replace('.', '/');

    public static void shieldWebapp(File webInfDir, Log log, boolean useShieldingRepository) throws MojoExecutionException {
        Document webAppDoc;
        String webInfSlashWebXml;
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Shielding web application in " + webInfDir));
        }
        if (!new File(webInfSlashWebXml = webInfDir.getPath() + File.separatorChar + "web.xml").exists()) {
            throw new MojoExecutionException("No web.xml present - can't add shielded class loading");
        }
        log.info((CharSequence)"Adding shielded classloader configuration to web application configuration.");
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Reading web.xml: " + webInfSlashWebXml));
        }
        try {
            webAppDoc = XMLUtils.parseXml(new File(webInfSlashWebXml));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to read web.xml from " + webInfSlashWebXml, e);
        }
        WebXmlRewriter webXmlRewriter = new WebXmlRewriter(ShieldingServlet.class.getName(), ShieldingListener.class.getName(), ShieldingServletFilter.class.getName(), useShieldingRepository);
        if (webXmlRewriter.rewrite(webAppDoc)) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Writing web.xml: " + webInfSlashWebXml));
                }
                XMLUtils.write(webAppDoc, new FileOutputStream(webInfSlashWebXml));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to write web.xml to " + webInfSlashWebXml, e);
            }
        }
        if (useShieldingRepository) {
            log.info((CharSequence)"Moving classes and libs to shielded location.");
            try {
                WebApplicationRewriter.move(webInfDir, "lib", "shielded/lib", log);
                WebApplicationRewriter.move(webInfDir, "classes", "shielded/classes", log);
            }
            catch (IOException e) {
                throw new MojoExecutionException("unable to shield classes/libs", (Exception)e);
            }
        }
        String rsrc = ShieldedClassLoaderManager.class.getName().replace('.', '/') + ".class";
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Searching class file for: " + rsrc));
        }
        try {
            Enumeration<URL> e = WebApplicationRewriter.class.getClassLoader().getResources(rsrc);
            boolean found = false;
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Found class in " + url));
                }
                if (!url.getProtocol().equals("jar")) continue;
                String jarUrlString = url.toExternalForm();
                int pos = jarUrlString.indexOf(33);
                jarUrlString = jarUrlString.substring(0, pos + 2);
                URL jarUrl = new URL(jarUrlString);
                JarURLConnection connection = (JarURLConnection)jarUrl.openConnection();
                JarFile jarFile = connection.getJarFile();
                File destFile = new File(webInfDir, "lib" + File.separator + CLASSLOADER_JAR);
                JarOutputStream jos = new JarOutputStream(new FileOutputStream(destFile));
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry current = entries.nextElement();
                    if (!current.getName().startsWith(JAR_ENTRY_PREFIX)) continue;
                    jos.putNextEntry(current);
                    IOUtil.copy((InputStream)jarFile.getInputStream(current), (OutputStream)jos);
                    jos.closeEntry();
                }
                jos.close();
                found = true;
            }
            if (!found) {
                throw new MojoExecutionException("Unable to find jar file for shielded class loading classes.");
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("unable to find classes for shielded class loading.", (Exception)ioe);
        }
    }

    private static void move(File parentDir, String srcDir, String destDirOrig, Log log) throws IOException {
        File srcDirectory;
        String destDir = destDirOrig;
        if (File.separatorChar != '/') {
            destDir = destDir.replace('/', File.separatorChar);
        }
        if ((srcDirectory = new File(parentDir, srcDir)).exists() && srcDirectory.isDirectory()) {
            File destDirectory = new File(parentDir, destDir);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Deleting directory " + destDirectory));
            }
            FileUtils.deleteDirectory((File)destDirectory);
            destDirectory = new File(parentDir, destDir);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Recreating directory " + destDirectory));
            }
            destDirectory.mkdirs();
            File[] files = srcDirectory.listFiles();
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].getName().equals(CLASSLOADER_JAR)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Moving " + files[i] + " to " + destDirectory));
                    }
                    files[i].renameTo(new File(destDirectory, files[i].getName()));
                }
            }
        }
    }
}

