/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer.monolithic;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.cocoon.maven.deployer.monolithic.FileDeployer;
import org.apache.cocoon.maven.deployer.utils.WildcardHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.logging.Log;

public class RuleBasedZipExtractor {
    private Log logger;
    private File basedir;
    private List rules = new ArrayList();
    private Set alreadyDeployedFilesSet = new HashSet();

    public RuleBasedZipExtractor(File basedir, Log logger) {
        Validate.notNull((Object)basedir, (String)"The basedir of the server mustn't be null.");
        Validate.notNull((Object)logger, (String)"A logger must be set.");
        this.basedir = basedir;
        this.logger = logger;
        this.logger.debug((CharSequence)("Basedir: " + basedir.getAbsolutePath()));
    }

    public void addRule(String pattern, FileDeployer fileDeployer) {
        fileDeployer.setBasedir(this.basedir);
        fileDeployer.setLogger(this.logger);
        fileDeployer.setAlreadyDeployedFilesSet(this.alreadyDeployedFilesSet);
        this.rules.add(new Rule(pattern, fileDeployer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(File zipFile) throws IOException {
        ZipInputStream zipStream = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry document = null;
        try {
            do {
                if ((document = zipStream.getNextEntry()) == null) continue;
                if (document.isDirectory()) {
                    zipStream.closeEntry();
                    continue;
                }
                OutputStream out = null;
                try {
                    FileDeployer fileDeployer = this.findFileDeployer(document.getName());
                    if (fileDeployer == null) continue;
                    out = new BufferedOutputStream(fileDeployer.writeResource(document.getName()));
                    IOUtils.copy((InputStream)zipStream, (OutputStream)out);
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                zipStream.closeEntry();
            } while (document != null);
        }
        finally {
            zipStream.close();
        }
    }

    protected FileDeployer findFileDeployer(String name) {
        Iterator it = this.rules.iterator();
        while (it.hasNext()) {
            Rule rule = (Rule)it.next();
            HashMap resultMap = new HashMap();
            if (!WildcardHelper.match(resultMap, name, rule.compiledPattern)) continue;
            this.logger.debug((CharSequence)("findFileDeployer: " + name + " matched with pattern '" + rule.patternString));
            return rule.fileDeployer;
        }
        return null;
    }

    private static class Rule {
        String patternString;
        int[] compiledPattern;
        FileDeployer fileDeployer;

        public Rule(String pattern, FileDeployer fileDeployer) {
            this.patternString = pattern;
            this.compiledPattern = WildcardHelper.compilePattern(pattern);
            this.fileDeployer = fileDeployer;
        }
    }
}

