/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer.monolithic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.apache.cocoon.maven.deployer.monolithic.FileAlreadyDeployedException;
import org.apache.cocoon.maven.deployer.monolithic.FileDeployer;
import org.apache.cocoon.maven.deployer.utils.FileUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.logging.Log;

public class SingleFileDeployer
implements FileDeployer {
    private File basedir;
    private Log logger;
    private String outputDir;
    private boolean skipRootDirectory;
    private Set alreadyDeployedFilesSet;

    public SingleFileDeployer(String outputDir, boolean skipRootDirectory) {
        Validate.notNull((Object)outputDir, (String)"An outputDir has to be set.");
        this.outputDir = outputDir;
        this.skipRootDirectory = skipRootDirectory;
    }

    public SingleFileDeployer(String outputDir) {
        this(outputDir, false);
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    protected File getBasedir() {
        return this.basedir;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    protected Log getLogger() {
        return this.logger;
    }

    public void setAlreadyDeployedFilesSet(Set alreadyDeployedFilesSet) {
        this.alreadyDeployedFilesSet = alreadyDeployedFilesSet;
    }

    protected String getFileName(String documentName) {
        return documentName.substring(documentName.lastIndexOf(47) + 1);
    }

    protected String getOutputDir() {
        return this.outputDir;
    }

    public OutputStream writeResource(String documentName) throws IOException {
        File outDir = new File(this.getBasedir(), this.getOutputDir());
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        String outputDocumentName = documentName;
        if (this.skipRootDirectory) {
            outputDocumentName = this.removeRootDirectory(documentName);
            this.logger.debug((CharSequence)("Changing output document name from '" + documentName + "', to '" + outputDocumentName + "'."));
        } else {
            outputDocumentName = this.getFileName(documentName);
        }
        File targetFile = FileUtils.createPath(new File(outDir, outputDocumentName));
        if (this.alreadyDeployedFilesSet.contains(targetFile.getCanonicalFile())) {
            throw new FileAlreadyDeployedException("File '" + targetFile + "' already exists!");
        }
        this.alreadyDeployedFilesSet.add(targetFile.getCanonicalFile());
        this.logger.debug((CharSequence)("Deploying block resource to " + this.getOutputDir() + "/" + outputDocumentName));
        return new FileOutputStream(FileUtils.createPath(targetFile));
    }

    protected String removeRootDirectory(String documentName) {
        return documentName.substring(documentName.indexOf(47) + 1);
    }
}

