/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer.monolithic;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cocoon.maven.deployer.monolithic.DeploymentException;
import org.apache.cocoon.maven.deployer.monolithic.SingleFileDeployer;
import org.apache.cocoon.maven.deployer.utils.CopyUtils;
import org.apache.cocoon.maven.deployer.utils.FileUtils;
import org.apache.cocoon.maven.deployer.utils.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPatchDeployer
extends SingleFileDeployer {
    final List patches = new Vector();

    public XPatchDeployer(String outputDir) {
        super(outputDir, false);
    }

    public OutputStream writeResource(String documentName) throws IOException {
        this.getLogger().debug((CharSequence)("catching patch: " + documentName));
        PatchCachingOutputStream out = new PatchCachingOutputStream(documentName);
        this.patches.add(out);
        return out;
    }

    public void addPatch(File file) throws IOException {
        this.getLogger().debug((CharSequence)("catching patch: " + file.getAbsolutePath()));
        PatchCachingOutputStream pcis = new PatchCachingOutputStream(file.getCanonicalPath());
        CopyUtils.copy(new FileInputStream(file), pcis);
        this.patches.add(pcis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPatches(InputStream source, String fileName) {
        try {
            if (this.patches.size() == 0) {
                this.getLogger().info((CharSequence)"No patches to apply");
            } else {
                this.getLogger().info((CharSequence)("Applying patches to: " + fileName));
            }
            Document original = XMLUtils.parseXml(source);
            File outFile = FileUtils.createPath(new File(this.getBasedir(), fileName));
            Iterator it = this.patches.iterator();
            while (it.hasNext()) {
                PatchCachingOutputStream pcis = (PatchCachingOutputStream)it.next();
                Document component = pcis.getPatch();
                Element elem = component.getDocumentElement();
                if (!elem.getTagName().equals("xweb")) {
                    throw new DeploymentException("not a valid xweb patch file: " + pcis.getDocumentName());
                }
                String xpath = elem.getAttribute("xpath");
                if (xpath == null) {
                    throw new DeploymentException("no xpath parameter in patch file: " + pcis.getDocumentName());
                }
                NodeList nodes = XPathAPI.selectNodeList((Node)original, (String)xpath);
                if (nodes.getLength() == 0) {
                    throw new DeploymentException("no matches for xpath: [" + xpath + "] in patch file: " + pcis.getDocumentName());
                }
                if (nodes.getLength() > 1) {
                    throw new DeploymentException("multiple matches for xpath: [" + xpath + "] in patch file: " + pcis.getDocumentName());
                }
                Node root = nodes.item(0);
                String testPath = elem.getAttribute("unless-path");
                if (testPath == null || testPath.length() == 0) {
                    testPath = elem.getAttribute("unless");
                }
                if (testPath != null && testPath.length() > 0 && XPathAPI.eval((Node)root, (String)testPath).bool()) {
                    this.getLogger().debug((CharSequence)("skipping application of patch file: " + pcis.getDocumentName()));
                    continue;
                }
                xpath = elem.getAttribute("remove");
                if (xpath != null && xpath.length() > 0) {
                    nodes = XPathAPI.selectNodeList((Node)original, (String)xpath);
                    int length = nodes.getLength();
                    for (int i = 0; i < length; ++i) {
                        Node node = nodes.item(i);
                        Node parent = node.getParentNode();
                        parent.removeChild(node);
                    }
                }
                String name = elem.getAttribute("add-attribute");
                String value = elem.getAttribute("value");
                if (name != null && name.length() > 0 && value != null && root instanceof Element) {
                    ((Element)root).setAttribute(name, value);
                }
                if (root instanceof Element) {
                    NamedNodeMap attrMap = elem.getAttributes();
                    for (int i = 0; i < attrMap.getLength(); ++i) {
                        Attr attr = (Attr)attrMap.item(i);
                        String addAttr = "add-attribute-";
                        if (!attr.getName().startsWith("add-attribute-")) continue;
                        String key = attr.getName().substring("add-attribute-".length());
                        ((Element)root).setAttribute(key, attr.getValue());
                    }
                }
                xpath = elem.getAttribute("insert-before");
                Node before = null;
                if (xpath != null && xpath.length() > 0) {
                    nodes = XPathAPI.selectNodeList((Node)root, (String)xpath);
                    if (nodes.getLength() != 0) {
                        before = nodes.item(0);
                    }
                } else {
                    xpath = elem.getAttribute("insert-after");
                    if (xpath != null && xpath.length() > 0 && (nodes = XPathAPI.selectNodeList((Node)root, (String)xpath)).getLength() != 0) {
                        before = nodes.item(nodes.getLength() - 1).getNextSibling();
                    }
                }
                NodeList componentNodes = component.getDocumentElement().getChildNodes();
                for (int i = 0; i < componentNodes.getLength(); ++i) {
                    Node node = original.importNode(componentNodes.item(i), true);
                    if (before == null) {
                        root.appendChild(node);
                        continue;
                    }
                    root.insertBefore(node, before);
                }
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
            try {
                this.getLogger().debug((CharSequence)("Deploying resource file to " + fileName));
                transformer.transform(new DOMSource(original), new StreamResult(os));
            }
            finally {
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException("Can't write to nonexistant file " + fileName, e);
        }
        catch (IOException e) {
            throw new DeploymentException("Can't write to " + fileName, e);
        }
        catch (ParserConfigurationException e) {
            throw new DeploymentException("Unable to configure parser " + fileName, e);
        }
        catch (SAXException e) {
            throw new DeploymentException("Unable to parse XML " + fileName, e);
        }
        catch (TransformerConfigurationException e) {
            throw new DeploymentException("Unable to configure transformer " + fileName, e);
        }
        catch (TransformerException e) {
            throw new DeploymentException("Unable to transform XML " + fileName, e);
        }
    }

    private class PatchCachingOutputStream
    extends ByteArrayOutputStream {
        private String documentName;

        public String getDocumentName() {
            return this.documentName;
        }

        public PatchCachingOutputStream(String documentName) {
            this.documentName = documentName;
        }

        public Document getPatch() throws SAXException, IOException, ParserConfigurationException {
            return XMLUtils.parseXml(new ByteArrayInputStream(this.buf, 0, this.count));
        }
    }
}

