/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cocoon.maven.deployer.servlet.ShieldedClassLoaderManager;

public class ShieldingServletFilter
implements Filter {
    protected Filter filter;
    protected ClassLoader classloader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filter != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classloader);
                this.filter.doFilter(request, response, chain);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig config) throws ServletException {
        this.classloader = ShieldedClassLoaderManager.getClassLoader(config.getServletContext());
        String filterName = config.getInitParameter("filter-class");
        if (filterName == null) {
            throw new ServletException("ShieldingServletFilter: 'filter-class' parameter is missing.");
        }
        ShieldedClassLoaderManager.logDebug(config.getServletContext(), "ShieldingServletFilter: Loading filter class " + filterName);
        try {
            Class<?> filterClass = this.classloader.loadClass(filterName);
            this.filter = (Filter)filterClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Cannot load filter " + filterName, (Throwable)e);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            this.filter.init(config);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.filter != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classloader);
                this.filter.destroy();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

