/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.rcl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.cocoon.maven.deployer.AbstractDeployMojo;
import org.apache.cocoon.maven.deployer.WebXmlRewriter;
import org.apache.cocoon.maven.deployer.utils.XMLUtils;
import org.apache.cocoon.maven.rcl.RwmProperties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PrepareWebappMojo
extends AbstractMojo {
    private static final String LIB_VERSION_WRAPPER = "1.0.0-M2";
    private static final String LIB_VERSION_SPRING_RELOADER = "1.0.0-M2";
    private static final String WEB_INF_WEB_XML = "WEB-INF/web.xml";
    private static final String WEB_INF_APP_CONTEXT = "WEB-INF/applicationContext.xml";
    private static final String WEB_INF_LOG4J = "WEB-INF/log4j.xml";
    private static final String WEB_INF_LIB = "WEB-INF/lib";
    private static final String WEB_INF_COCOON_SPRING_PROPS = "WEB-INF/cocoon/spring/rcl.properties";
    private static final String WEB_INF_COCOON_PROPS = "WEB-INF/cocoon/properties/rcl.properties";
    private static final String WEB_INF_RCL_URLCL_CONF = "WEB-INF/cocoon/rclwrapper.urlcl.conf";
    private static final String WEB_INF_RCLWRAPPER_RCL_CONF = "WEB-INF/cocoon/rclwrapper.rcl.conf";
    private static final String WEB_INF_RCLWRAPPER_PROPERTIES = "/WEB-INF/cocoon/rclwrapper.properties";
    private File target;
    private File rclPropertiesFile;
    private boolean useSocketAppender = false;
    private boolean useConsoleAppender = false;
    private boolean reloadingSpringEnabled = true;
    private boolean reloadingClassLoaderEnabled = true;
    private String customLog4jXconf;
    private File customWebappDirectory;
    private String webappProfile = "cocoon-22";
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private List remoteArtifactRepositories;
    private ArtifactRepository localRepository;
    private MavenMetadataSource metadataSource;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (!this.project.getPackaging().equals("jar") || !this.rclPropertiesFile.exists()) {
            this.getLog().info((CharSequence)"Don't execute the Cocoon RCL plugin becaues either its packaging type is not 'jar' or there is no rcl.properties file in the block's base directory.");
            return;
        }
        if ("cocoon-22".equals(this.webappProfile)) {
            this.getLog().info((CharSequence)"Preparing a Cocoon web application.");
        } else if ("ssf".equals(this.webappProfile)) {
            this.getLog().info((CharSequence)"Preparing a Servlet-Service web application.");
        } else {
            throw new MojoExecutionException("Only the profiles 'cocoon-22' and 'ssf' are supported.");
        }
        File webAppBaseDir = new File(this.target, "webapp");
        this.writeInputStreamToFile(this.readResourceFromClassloader(WEB_INF_WEB_XML), PrepareWebappMojo.createPath(new File(webAppBaseDir, WEB_INF_WEB_XML)));
        this.writeInputStreamToFile(this.readResourceFromClassloader(WEB_INF_APP_CONTEXT), PrepareWebappMojo.createPath(new File(webAppBaseDir, WEB_INF_APP_CONTEXT)));
        this.writeLog4jXml(webAppBaseDir);
        this.copyCustomWebappDirectory(webAppBaseDir);
        this.copyRclWrapperLibs(webAppBaseDir);
        RwmProperties props = this.readProperties();
        this.createUrlClassLoaderConf(webAppBaseDir, props);
        this.createReloadingClassLoaderConf(webAppBaseDir, props);
        this.createSpringProperties(webAppBaseDir, props);
        this.createCocoonProperties(webAppBaseDir, props);
        this.createProperties(webAppBaseDir);
        this.applyXpatchFiles(webAppBaseDir, props);
        this.rewriteWebXml(webAppBaseDir);
    }

    protected RwmProperties readProperties() throws MojoExecutionException {
        RwmProperties props = null;
        try {
            props = new RwmProperties(this.rclPropertiesFile, this.project.getBasedir());
        }
        catch (ConfigurationException e) {
            throw new MojoExecutionException("Can't read " + this.rclPropertiesFile.getAbsolutePath(), (Exception)((Object)e));
        }
        return props;
    }

    protected void createReloadingClassLoaderConf(File webAppBaseDir, RwmProperties props) throws MojoExecutionException {
        File urlClConfFile = PrepareWebappMojo.createPath(new File(webAppBaseDir, WEB_INF_RCLWRAPPER_RCL_CONF));
        try {
            FileWriter fw = new FileWriter(urlClConfFile);
            Iterator aIt = props.getClassesDirs().iterator();
            while (aIt.hasNext()) {
                String dir = (String)aIt.next();
                fw.write(dir + "\n");
                this.getLog().debug((CharSequence)("Adding classes-dir to RCLClassLoader configuration: " + dir));
            }
            fw.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while writing to " + urlClConfFile, (Exception)e);
        }
    }

    protected void createUrlClassLoaderConf(File webAppBaseDir, RwmProperties props) throws MojoExecutionException {
        File urlClConfFile = PrepareWebappMojo.createPath(new File(webAppBaseDir, WEB_INF_RCL_URLCL_CONF));
        try {
            FileWriter fw = new FileWriter(urlClConfFile);
            Set excludeLibProps = props.getExcludedLibProps();
            Iterator aIt = props.getClassesDirs().iterator();
            while (aIt.hasNext()) {
                String dir = (String)aIt.next();
                fw.write(dir + "\n");
                this.getLog().debug((CharSequence)("Adding classes-dir (URLClassLoader configuration): " + dir));
            }
            Set artifacts = this.project.getArtifacts();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            Set springReloaderArtifacts = this.getDependencies("org.apache.cocoon", "cocoon-rcl-spring-reloader", "1.0.0-M2", "jar");
            artifacts.addAll(springReloaderArtifacts);
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                if (!artifact.isOptional() && filter.include(artifact) && !excludeLibProps.contains(artifact.getGroupId() + ":" + artifact.getArtifactId())) {
                    fw.write(artifact.getFile().toURL().toExternalForm() + "\n");
                    this.getLog().debug((CharSequence)("Adding library (URLClassLoader configuration): " + artifact.getArtifactId()));
                    continue;
                }
                this.getLog().debug((CharSequence)("Skipping library (URLClassLoader configuration): " + artifact.getArtifactId()));
            }
            fw.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while writing to " + urlClConfFile, (Exception)e);
        }
    }

    protected void createSpringProperties(File webAppBaseDir, RwmProperties props) throws MojoExecutionException {
        File springPropFile = PrepareWebappMojo.createPath(new File(webAppBaseDir, WEB_INF_COCOON_SPRING_PROPS));
        try {
            FileOutputStream springPropsOs = new FileOutputStream(springPropFile);
            props.getSpringProperties().store(springPropsOs, "Spring properties as read from " + this.rclPropertiesFile.toURL());
            springPropsOs.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write to  " + springPropFile.getAbsolutePath(), (Exception)e);
        }
    }

    protected void createCocoonProperties(File webAppBaseDir, RwmProperties props) throws MojoExecutionException {
        File springPropFile = PrepareWebappMojo.createPath(new File(webAppBaseDir, WEB_INF_COCOON_PROPS));
        try {
            FileOutputStream springPropsOs = new FileOutputStream(springPropFile);
            props.getCocoonProperties().store(springPropsOs, "Cocoon properties as read from " + this.rclPropertiesFile.toURL());
            springPropsOs.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write to  " + springPropFile.getAbsolutePath(), (Exception)e);
        }
    }

    protected void copyRclWrapperLibs(File webAppBaseDir) throws MojoExecutionException {
        Set rclWebappDependencies = this.getDependencies("org.apache.cocoon", "cocoon-rcl-webapp-wrapper", "1.0.0-M2", "jar");
        Iterator rclIt = rclWebappDependencies.iterator();
        while (rclIt.hasNext()) {
            Artifact artifact = (Artifact)rclIt.next();
            try {
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)PrepareWebappMojo.createPath(new File(webAppBaseDir, WEB_INF_LIB)));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't copy artifact " + artifact);
            }
            this.getLog().info((CharSequence)("Adding lib to WEB-INF/lib: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getType()));
        }
    }

    protected void createProperties(File webAppBaseDir) throws MojoExecutionException {
        File rclProps = PrepareWebappMojo.createPath(new File(webAppBaseDir, WEB_INF_RCLWRAPPER_PROPERTIES));
        try {
            Properties props = new Properties();
            props.setProperty("reloading.spring.enabled", Boolean.toString(this.reloadingSpringEnabled));
            props.setProperty("reloading.classloader.enabled", Boolean.toString(this.reloadingClassLoaderEnabled));
            props.save(new FileOutputStream(rclProps), "Reloading Classloader Properties");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write to  " + rclProps.getAbsolutePath(), (Exception)e);
        }
    }

    protected void writeLog4jXml(File webAppBaseDir) throws MojoExecutionException {
        HashMap<String, Boolean> log4jTemplateMap = new HashMap<String, Boolean>();
        log4jTemplateMap.put("useConsoleAppender", new Boolean(this.useConsoleAppender));
        log4jTemplateMap.put("useSocketAppender", new Boolean(this.useSocketAppender));
        this.writeStringTemplateToFile(webAppBaseDir, WEB_INF_LOG4J, this.customLog4jXconf, log4jTemplateMap);
    }

    protected void copyCustomWebappDirectory(File webAppBaseDir) throws MojoExecutionException {
        if (this.customWebappDirectory == null) {
            return;
        }
        if (!this.customWebappDirectory.exists()) {
            throw new MojoExecutionException("The custom web application directory does not exist.");
        }
        if (!this.customWebappDirectory.isDirectory()) {
            throw new MojoExecutionException("The value of the parameter 'customWebappDirectory' doesn't point to a directory.");
        }
        try {
            FileUtils.copyDirectory((File)this.customWebappDirectory, (File)webAppBaseDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't copy custom webapp files (directory: '" + this.customWebappDirectory + ") to the web application in preparation.");
        }
    }

    protected void applyXpatchFiles(File webAppBaseDir, RwmProperties props) throws MojoExecutionException {
        Set classesDirs = props.getClassesDirs();
        File[] allXPatchFiles = new File[]{};
        Iterator it = classesDirs.iterator();
        while (it.hasNext()) {
            String f = RwmProperties.calcRootDir((String)it.next());
            try {
                File f1 = new File(new File(new URI(f)), "src/main/resources/META-INF/cocoon/xpatch");
                File[] xmlFiles = f1.listFiles(new FilenameFilter(){

                    public boolean accept(File d, String name) {
                        return name.toLowerCase().endsWith(".xweb");
                    }
                });
                if (xmlFiles == null) continue;
                File[] mergedArray = new File[allXPatchFiles.length + xmlFiles.length];
                System.arraycopy(allXPatchFiles, 0, mergedArray, 0, allXPatchFiles.length);
                System.arraycopy(xmlFiles, 0, mergedArray, allXPatchFiles.length, xmlFiles.length);
                allXPatchFiles = mergedArray;
            }
            catch (URISyntaxException e) {}
        }
        Map libs = AbstractDeployMojo.getBlockArtifactsAsMap(this.project, this.getLog());
        AbstractDeployMojo.xpatch(libs, allXPatchFiles, webAppBaseDir, this.getLog());
    }

    protected void rewriteWebXml(File webAppBaseDir) throws MojoExecutionException {
        Document webXmlDocument;
        File webXml = new File(webAppBaseDir, WEB_INF_WEB_XML);
        try {
            webXmlDocument = XMLUtils.parseXml(webXml);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem while reading from " + webXml);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Problem while parsing " + webXml);
        }
        WebXmlRewriter webXmlRewriter = new WebXmlRewriter("org.apache.cocoon.tools.rcl.wrapper.servlet.ReloadingServlet", "org.apache.cocoon.tools.rcl.wrapper.servlet.ReloadingListener", "org.apache.cocoon.tools.rcl.wrapper.servlet.ReloadingServletFilter", false);
        if (webXmlRewriter.rewrite(webXmlDocument)) {
            try {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Rewriting web.xml: " + webXml));
                }
                XMLUtils.write(webXmlDocument, new FileOutputStream(webXml));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to write web.xml to " + webXml, e);
            }
        }
    }

    protected Set getDependencies(String groupId, String artifactId, String version, String packaging) throws MojoExecutionException {
        HashSet<Artifact> returnSet = new HashSet<Artifact>();
        try {
            Artifact artifact;
            Set artifacts = null;
            ArtifactResolutionResult result = null;
            Dependency dependency = new Dependency();
            dependency.setGroupId(groupId);
            dependency.setArtifactId(artifactId);
            dependency.setVersion(version);
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            dependencies.add(dependency);
            Artifact pomArtifact = this.artifactFactory.createBuildArtifact("unspecified", "unspecified", "0.0", "jar");
            Map managedDependencies = Collections.EMPTY_MAP;
            artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, dependencies, (String)"compile", null, null);
            result = this.artifactResolver.resolveTransitively(artifacts, pomArtifact, managedDependencies, this.localRepository, this.remoteArtifactRepositories, (ArtifactMetadataSource)this.metadataSource);
            Iterator i = artifacts.iterator();
            while (i.hasNext()) {
                artifact = (Artifact)i.next();
                returnSet.add(artifact);
            }
            i = result.getArtifacts().iterator();
            while (i.hasNext()) {
                artifact = (Artifact)i.next();
                returnSet.add(artifact);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Can't resolve artifact " + groupId + ":" + artifactId + ":" + version, (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Can't find artifact " + groupId + ":" + artifactId + ":" + version, (Exception)((Object)e));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("Invalid version of artifact " + groupId + ":" + artifactId + ":" + version, (Exception)((Object)e));
        }
        return returnSet;
    }

    protected void writeStringTemplateToFile(File basedir, String fileName, String customFile, Map templateObjects) throws MojoExecutionException {
        OutputStream fos = null;
        try {
            File outFile = PrepareWebappMojo.createPath(new File(basedir, fileName));
            fos = new BufferedOutputStream(new FileOutputStream(outFile));
            InputStream fileIs = null;
            if (customFile != null) {
                if (new File(customFile).exists()) {
                    fileIs = new BufferedInputStream(new FileInputStream(customFile));
                } else {
                    this.getLog().info((CharSequence)("supplied custom file " + customFile + " doesn't exist. Fallback to default: " + fileName));
                    fileIs = this.readResourceFromClassloader(fileName);
                }
            } else {
                fileIs = this.readResourceFromClassloader(fileName);
            }
            StringTemplate stringTemplate = new StringTemplate(IOUtils.toString((InputStream)fileIs));
            Iterator templateObjectsIt = templateObjects.keySet().iterator();
            while (templateObjectsIt.hasNext()) {
                Object key = templateObjectsIt.next();
                stringTemplate.setAttribute((String)key, templateObjects.get(key));
            }
            this.getLog().info((CharSequence)("Deploying string-template to " + fileName));
            IOUtils.write((String)stringTemplate.toString(), (OutputStream)fos);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException((customFile == null ? fileName : customFile) + " not found.", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading or writing.", (Exception)e);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while closing the output stream.", (Exception)e);
            }
        }
    }

    protected InputStream readResourceFromClassloader(String fileName) {
        String resource = PrepareWebappMojo.class.getPackage().getName().replace('.', '/') + "/profiles/" + this.webappProfile + "/" + fileName;
        return PrepareWebappMojo.class.getClassLoader().getResourceAsStream(resource);
    }

    protected static File createPath(File file) {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    protected void writeInputStreamToFile(InputStream is, File f) throws MojoExecutionException {
        Validate.notNull((Object)is);
        Validate.notNull((Object)f);
        try {
            FileWriter fw = new FileWriter(f);
            IOUtils.copy((InputStream)is, (Writer)fw);
            fw.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write to file " + f);
        }
    }
}

