/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer;

import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.maven.deployer.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebXmlRewriter {
    private String servletClass;
    private String listenerClass;
    private String filterClass;
    private boolean useShieldingRepositoryParameter;

    public WebXmlRewriter(String servletClass, String listenerClass, String filterClass, boolean useShieldingRepository) {
        this.servletClass = servletClass;
        this.listenerClass = listenerClass;
        this.filterClass = filterClass;
        this.useShieldingRepositoryParameter = useShieldingRepository;
    }

    public boolean rewrite(Document webAppDoc) {
        String className;
        boolean rewritten = false;
        Element rootElement = webAppDoc.getDocumentElement();
        List servlets = XMLUtils.getChildNodes(rootElement, "servlet");
        Iterator i = servlets.iterator();
        while (i.hasNext()) {
            Element servletElement = (Element)i.next();
            Element servletClassElement = XMLUtils.getChildNode(servletElement, "servlet-class");
            if (servletClassElement == null) continue;
            String className2 = XMLUtils.getValue(servletClassElement);
            XMLUtils.setValue(servletClassElement, this.servletClass);
            Element initParamElem = webAppDoc.createElementNS(null, "init-param");
            Element initParamNameElem = webAppDoc.createElementNS(null, "param-name");
            Element initParamValueElem = webAppDoc.createElementNS(null, "param-value");
            initParamElem.appendChild(initParamNameElem);
            initParamElem.appendChild(initParamValueElem);
            XMLUtils.setValue(initParamNameElem, "servlet-class");
            XMLUtils.setValue(initParamValueElem, className2);
            Element beforeElement = XMLUtils.getChildNode(servletElement, "load-on-startup");
            if (beforeElement == null && (beforeElement = XMLUtils.getChildNode(servletElement, "run-as")) == null) {
                beforeElement = XMLUtils.getChildNode(servletElement, "security-role-ref");
            }
            if (beforeElement == null) {
                servletElement.appendChild(initParamElem);
            } else {
                servletElement.insertBefore(initParamElem, beforeElement);
            }
            rewritten = true;
        }
        List listeners = XMLUtils.getChildNodes(rootElement, "listener");
        i = listeners.iterator();
        boolean hasListener = false;
        StringBuffer rewrittenListeners = new StringBuffer();
        while (i.hasNext()) {
            Element listenerElement = (Element)i.next();
            Element listenerClassElement = XMLUtils.getChildNode(listenerElement, "listener-class");
            if (listenerClassElement == null) continue;
            className = XMLUtils.getValue(listenerClassElement);
            if (rewrittenListeners.length() > 0) {
                rewrittenListeners.append(',');
            }
            rewrittenListeners.append(className);
            if (hasListener) {
                rootElement.removeChild(listenerElement);
            } else {
                XMLUtils.setValue(listenerClassElement, this.listenerClass);
                hasListener = true;
            }
            rewritten = true;
        }
        i = XMLUtils.getChildNodes(rootElement, "context-param").iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            if (!this.listenerClass.equals(XMLUtils.getValue(XMLUtils.getChildNode(child, "param-name")))) continue;
            rootElement.removeChild(child);
        }
        if (hasListener) {
            WebXmlRewriter.addContextParameter(rootElement, this.listenerClass, rewrittenListeners.toString());
        }
        i = XMLUtils.getChildNodes(rootElement, "filter").iterator();
        while (i.hasNext()) {
            Element filterElement = (Element)i.next();
            Element filterClassElement = XMLUtils.getChildNode(filterElement, "filter-class");
            if (filterClassElement == null) continue;
            className = XMLUtils.getValue(filterClassElement);
            XMLUtils.setValue(filterClassElement, this.filterClass);
            Element initParamElem = webAppDoc.createElementNS(null, "init-param");
            Element initParamNameElem = webAppDoc.createElementNS(null, "param-name");
            Element initParamValueElem = webAppDoc.createElementNS(null, "param-value");
            initParamElem.appendChild(initParamNameElem);
            initParamElem.appendChild(initParamValueElem);
            XMLUtils.setValue(initParamNameElem, "filter-class");
            XMLUtils.setValue(initParamValueElem, className);
            filterElement.appendChild(initParamElem);
            rewritten = true;
        }
        if (!this.useShieldingRepositoryParameter) {
            WebXmlRewriter.addContextParameter(rootElement, "shieled-classloader-use-repository", "false");
            rewritten = true;
        } else if (WebXmlRewriter.removeContextParameter(rootElement, "shieled-classloader-use-repository")) {
            rewritten = true;
        }
        return rewritten;
    }

    protected static boolean removeContextParameter(Element root, String name) {
        boolean removed = false;
        Iterator i = XMLUtils.getChildNodes(root, "context-param").iterator();
        while (!removed && i.hasNext()) {
            Element parameterElement = (Element)i.next();
            String paramName = XMLUtils.getValue(XMLUtils.getChildNode(parameterElement, "param-name"));
            if (!name.equals(paramName)) continue;
            parameterElement.getParentNode().removeChild(parameterElement);
            removed = true;
        }
        return removed;
    }

    protected static void addContextParameter(Element root, String name, String value) {
        WebXmlRewriter.removeContextParameter(root, name);
        Element searchElement = XMLUtils.getChildNode(root, "context-param");
        if (searchElement == null && (searchElement = XMLUtils.getChildNode(root, "filter")) == null && (searchElement = XMLUtils.getChildNode(root, "filter-mapping")) == null) {
            searchElement = XMLUtils.getChildNode(root, "listener");
        }
        Element contextParamElement = root.getOwnerDocument().createElementNS(null, "context-param");
        Element contextParamNameElement = root.getOwnerDocument().createElementNS(null, "param-name");
        Element contextParamValueElement = root.getOwnerDocument().createElementNS(null, "param-value");
        contextParamElement.appendChild(contextParamNameElement);
        contextParamElement.appendChild(contextParamValueElement);
        XMLUtils.setValue(contextParamNameElement, name);
        XMLUtils.setValue(contextParamValueElement, value);
        root.insertBefore(contextParamElement, searchElement);
    }
}

